
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Rewards')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-4 col-lg-12 col-md-12 col-12">
            <!-- New My Reward Points Card -->
            <div class="site-card rewards-card" style="border-radius: 12px; overflow: hidden;">
                <div class="site-card-header">
                    <h4 class="title"><?php echo e(__('My Reward Points')); ?></h4>
                </div>
                <div class="site-card-body text-center">
                    <h3 class="acc-balance"><?php echo e(auth()->user()->points); ?></h3>
                    <a href="<?php echo e(route('user.rewards.redeem.now')); ?>" class="site-btn polis-btn mt-3">
                        <i data-lucide="gift"></i> <?php echo e(__('Redeem Now')); ?>

                    </a>
                    <?php if($myRanking): ?>
                        <div class="last-login mt-3"><?php echo e(__("Every :points reward points are :amount", ['points' => $myRanking->point, 'amount' => $currencySymbol.$myRanking->amount])); ?></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="col-xl-4 offset-xl-4 col-lg-12 col-md-12 col-12">
            <img src="<?php echo e(asset('front/images/reward.png')); ?>" alt="" class="rounded">
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-xl-6 col-lg-6 col-md-12">
            <div class="site-card" style="border-radius: 12px; overflow: hidden;">
                <div class="site-card-header">
                    <h4 class="title"><?php echo e(__('Reward Point Earnings:')); ?></h4>
                </div>
                <div class="site-card-body p-0 table-responsive" style="border-radius: 12px;">
                    <table class="display data-table site-custom-table site-custom-table-sm" style="width: 100%; border-collapse: collapse; border-radius: 12px; overflow: hidden;">
                        <thead>
                        <tr style="background-color: transparent; color: white;">
                            <th style="padding: 12px; text-align: left; width: 33%"><?php echo e(__('Ranking List')); ?></th>
                            <th style="padding: 12px; text-align: left; width: 33%"><?php echo e(__('Amount Of Transactions')); ?></th>
                            <th style="padding: 12px; text-align: left; width: 33%"><?php echo e(__('Reward')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $earnings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $earning): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr style="background-color: transparent; color: white;">
                                <td style="padding: 12px; text-align: left;"><?php echo e($earning->ranking->ranking); ?></td>
                                <td style="padding: 12px; text-align: left;"><?php echo e($earning->amount_of_transactions.' '.$currency); ?></td>
                                <td style="padding: 12px; text-align: left;"><?php echo e($earning->point); ?> <?php echo e(__('Points')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" style="text-align: center; padding: 12px; color: white;"><?php echo e(__('No Data Found')); ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-xl-6 col-lg-6 col-md-12">
            <div class="site-card" style="border-radius: 12px; overflow: hidden;">
                <div class="site-card-header">
                    <h4 class="title"><?php echo e(__('Reward Points Redeem:')); ?></h4>
                </div>
                <div class="site-card-body p-0 table-responsive" style="border-radius: 12px;">
                    <table class="display data-table site-custom-table site-custom-table-sm" style="width: 100%; border-collapse: collapse; border-radius: 12px; overflow: hidden;">
                        <thead>
                        <tr style="background-color: transparent; color: white;">
                            <th style="padding: 12px; text-align: left; width: 33%"><?php echo e(__('Ranking List')); ?></th>
                            <th style="padding: 12px; text-align: left; width: 33%"><?php echo e(__('Per Points')); ?></th>
                            <th style="padding: 12px; text-align: left; width: 33%"><?php echo e(__('Redeem Amount')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $redeems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $redeem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr style="background-color: transparent; color: white;">
                                <td style="padding: 12px; text-align: left;"><?php echo e($redeem->ranking->ranking); ?></td>
                                <td style="padding: 12px; text-align: left;"><?php echo e($redeem->point); ?> <?php echo e(__('Points')); ?></td>
                                <td style="padding: 12px; text-align: left;"><?php echo e($redeem->amount.' '.$currency); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" style="text-align: center; padding: 12px; color: white;"><?php echo e(__('No Data Found')); ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-xl-12 mt-4">
            <div class="site-card" style="border-radius: 12px; overflow: hidden;">
                <div class="site-card-header">
                    <h4 class="title"><?php echo e(__('Redeem Summary:')); ?></h4>
                </div>
                <div class="site-card-body p-0 table-responsive" style="border-radius: 12px;">
                    <table class="display data-table site-custom-table site-custom-table-sm" style="width: 100%; border-collapse: collapse; border-radius: 12px; overflow: hidden;">
                        <thead>
                        <tr style="background-color: transparent; color: white;">
                            <th style="padding: 12px; text-align: left; width: 25%"><?php echo e(__('Description')); ?></th>
                            <th style="padding: 12px; text-align: left; width: 25%"><?php echo e(__('Amount')); ?></th>
                            <th style="padding: 12px; text-align: left; width: 25%"><?php echo e(__('Redeemed Date')); ?></th>
                            <th style="padding: 12px; text-align: left; width: 25%"><?php echo e(__('Transaction Type')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr style="background-color: transparent; color: white;">
                                <td style="padding: 12px; text-align: left;"><?php echo e($transaction->description); ?></td>
                                <td style="padding: 12px; text-align: left;">
                                    <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    "fw-bold",
                                    "green-color" => isPlusTransaction($transaction->type),
                                    "red-color" => !isPlusTransaction($transaction->type)
                                    ]) ?>">
                                    <?php echo e(isPlusTransaction($transaction->type) ? '+' : '-'); ?><?php echo e($transaction->amount.' '.$currency); ?>

                                    </span>
                                </td>
                                <td style="padding: 12px; text-align: left;"><?php echo e($transaction->created_at); ?></td>
                                <td style="padding: 12px; text-align: left;">
                                    <span class="site-badge badge-primary"><?php echo e(ucfirst(str_replace('_',' ',$transaction->type->value))); ?></span>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" style="text-align: center; padding: 12px; color: white;"><?php echo e(__('No Data Found')); ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                    <?php echo e($transactions->links()); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ekobitt/public_html/app/Providers/../../resources/views/frontend/default/rewards/index.blade.php ENDPATH**/ ?>