<h3 class="title mb-4"><?php echo e(__('Edit Content')); ?></h3>

<div class="site-tab-bars">
    <ul class="nav nav-pills" id="pills-tab-render" role="tablist">
        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li class="nav-item" role="presentation">
                <a
                    href=""
                    class="nav-link  <?php echo e($loop->index == 0 ?'active' : ''); ?>"
                    id="pills-render-tab"
                    data-bs-toggle="pill"
                    data-bs-target="#<?php echo e($language->locale); ?>-render"
                    type="button"
                    role="tab"
                    aria-controls="pills-render"
                    aria-selected="true"
                ><i icon-name="languages"></i><?php echo e($language->name); ?></a
                >
            </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    </ul>
</div>

<div class="tab-content" id="pills-tabContent">


    <?php $__currentLoopData = $groupData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $landingContent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <div
            class="tab-pane fade <?php echo e($loop->index == 0 ?'show active' : ''); ?>"
            id="<?php echo e($key); ?>-render"
            role="tabpanel"
            aria-labelledby="pills-render-tab"
        >

            <div class="row">
                <div class="col-xl-12">
                    <form action="<?php echo e(route('admin.page.content-update')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e($landingContent['id']); ?>">
                        <input type="hidden" name="locale" value="<?php echo e($key); ?>">
                        <?php if($key == 'en'): ?>
                            <div class="site-input-groups">

                                <?php if($landingContent['type'] == 'whychooseus'): ?>
                                <div class="site-input-groups">
                                    <label for="" class="box-input-label"><?php echo e(__('Icon Type:')); ?></label>
                                    <select class="form-select" name="type" id="editIconTypes">
                                        <option value="class" <?php echo e(!content_exists($landingContent['icon']) ? 'selected' : ''); ?>><?php echo e(__('Icon Class')); ?></option>
                                        <option value="image" <?php echo e(content_exists($landingContent['icon']) ? 'selected' : ''); ?>><?php echo e(__('Image')); ?></option>
                                    </select>
                                </div>

                                <div class="site-input-groups" id="editClassField">
                                    <label for="" class="box-input-label"><?php echo e(__('Icon Class')); ?> <a class="link"
                                                                                                    href="https://fontawesome.com/icons"
                                                                                                    target="_blank"><?php echo e(__('Fontawesome')); ?></a>:</label>
                                    <input type="text" name="class_name" <?php if(!content_exists($landingContent['icon'])): ?> value="<?php echo e($landingContent['icon']); ?>" <?php endif; ?> class="box-input mb-0" placeholder="Icon Class"/>
                                </div>

                                <div class="site-input-groups" id="editImageField">
                                    <label class="box-input-label" for="editContentIcon"><?php echo e(__('Icon:')); ?></label>
                                    <div class="wrap-custom-file">
                                        <input type="file" name="icon" id="editContentIcon" accept=".gif, .jpg, .png"/>
                                        <label for="editContentIcon" class="file-ok"
                                        style="background-image: url(<?php echo e(asset($landingContent['icon'])); ?>)">
                                            <img class="upload-icon" src="<?php echo e(asset('global/materials/upload.svg')); ?>" alt=""/>
                                            <span><?php echo e(__('Upload Icon')); ?></span>
                                        </label>
                                    </div>
                                </div>

                                <?php elseif($landingContent['type'] == 'howitworks' || $landingContent['type'] == 'counter'): ?>
                                    <label class="box-input-label" for=""><?php echo e(__('Icon')); ?>:</label>
                                    <div class="wrap-custom-file">
                                        <input type="file" name="icon" id="heroRightImg"
                                               accept=".gif, .jpg, .png"/>
                                        <label for="heroRightImg" class="file-ok"
                                               style="background-image: url(<?php echo e(asset($landingContent['icon'])); ?>)">
                                            <img class="upload-icon"
                                                 src="<?php echo e(asset('global/materials/upload.svg')); ?>" alt=""/>
                                            <span><?php echo e(__('Update Image')); ?></span>
                                        </label>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <div class="site-input-groups">
                            <label for="" class="box-input-label"><?php echo e(__('Title:')); ?></label>
                            <input type="text" name="title" value="<?php echo e($landingContent['title']); ?>"
                                   class="box-input mb-0 title0" required=""/>
                        </div>
                        <div class="site-input-groups mb-0">
                            <label for="" class="box-input-label"><?php echo e(__('Description:')); ?></label>
                            <textarea name="description" class="form-textarea description"
                                      placeholder="Description"><?php echo e($landingContent['description']); ?></textarea>
                        </div>

                        <div class="action-btns">
                            <button type="submit" class="site-btn-sm primary-btn me-2">
                                <i icon-name="check"></i>
                                <?php echo e(__(' Save Changes')); ?>

                            </button>
                            <a
                                href="#"
                                class="site-btn-sm red-btn"
                                data-bs-dismiss="modal"
                                aria-label="Close"
                            >
                                <i icon-name="x"></i>
                                <?php echo e(__(' Close')); ?>

                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


</div>

<script>
    $('input[type="file"]').each(function () {
        // Refs
        var $file = $(this),
            $label = $file.next('label'),
            $labelText = $label.find('span'),
            labelDefault = $labelText.text();

        // When a new file is selected
        $file.on('change', function (event) {
            var fileName = $file.val().split('\\').pop(),
                tmppath = URL.createObjectURL(event.target.files[0]);
            //Check successfully selection
            if (fileName) {
                $label
                    .addClass('file-ok')
                    .css('background-image', 'url(' + tmppath + ')');
                $labelText.text(fileName);
            } else {
                $label.removeClass('file-ok');
                $labelText.text(labelDefault);
            }
        });
    });

    $('#editIconTypes').on('change',function(){
        initIconType();
    });
</script>
<?php /**PATH /home/ekobitt/public_html/resources/views/backend/page/section/include/__conten_edit_render.blade.php ENDPATH**/ ?>