

<?php $__env->startSection('title'); ?>
<?php echo e(__('Login')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<!-- Sign in area start -->
<div class="sign-in-area">
   <div class="auth-inner">
      <div class="auth-wrapper">
         <div class="auth-from-inner">
            <div class="auth-from-top-content">
               <div class="auth-logo">
                  <a href="<?php echo e(route('home')); ?>">
                     <img src="<?php echo e(asset(setting('site_logo','global'))); ?>" alt="logo" alt="logo">
                  </a>
               </div>

               <h3 class="title"><?php echo e($data['title']); ?></h3>
               <p class="description"><?php echo e($data['bottom_text']); ?></p>
            </div>
            <div class="auth-from-box">
               <?php if($errors->any()): ?>
               <div class="alert alert-warning alert-dismissible fade show" role="alert">
                  <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <strong><?php echo e($error); ?></strong>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
               </div>
               <?php endif; ?>
               <form action="<?php echo e(route('login')); ?>" method="POST" id="loginForm">
                  <?php echo csrf_field(); ?>
                  <div class="coinefy-single-input has-right-icon mb-25">
                     <div class="input-field">
                        <input type="email" name="email" class="box-input" placeholder="Enter username or email" required>
                        <span class="input-icon"><i class="fa-regular fa-user"></i></span>
                     </div>
                     <p class="feedback-invalid">This field is required</p>
                  </div>
                  <div class="coinefy-single-input has-right-icon mb-25">
                     <div class="input-field">
                        <input type="password" name="password" class="box-input password-input" placeholder="Password" required>
                        <span class="input-icon eyeicon"><i class="fa-sharp fa-light fa-eye-slash"></i></span>
                     </div>
                     <p class="feedback-invalid">This field is required</p>
                  </div>
                  <?php if($googleReCaptcha): ?>
                  <div class="g-recaptcha mb-3" id="feedback-recaptcha" data-sitekey="<?php echo e(json_decode($googleReCaptcha->data,true)['google_recaptcha_key']); ?>">
                  </div>
                  <?php endif; ?>
                  <div class="auth-login-option">
                     <div class="animate-custom">
                        <input class="inp-cbx" id="auth_remind" type="checkbox" style="display: none;">
                        <label class="cbx" for="auth_remind">
                           <span>
                              <svg width="12px" height="9px" viewbox="0 0 12 9">
                                 <polyline points="1 5 4 8 11 1"></polyline>
                              </svg>
                           </span>
                           <span><?php echo e(__('Remember me')); ?></span>
                        </label>
                     </div>
                     <?php if(Route::has('password.request')): ?>
                     <div class="forget-content">
                        <span><a href="<?php echo e(route('password.request')); ?>"><?php echo e(__('Forget Password')); ?></a></span>
                     </div>
                     <?php endif; ?>
                  </div>
                  <div class="auth-from-btn-wrap">
                     <button class="site-btn primary-btn w-100" form="loginForm" type="submit"><?php echo e(__('Account Login')); ?></button>
                  </div>
               </form>
            </div>
            <div class="auth-from-bottom-content">
               <div class="auth-account">
                  <p class="description"> <?php echo e(__("Don't have an account?")); ?><a class="link" href="<?php echo e(route('register')); ?>"> <?php echo e(__('Signup for free')); ?></a></p>
               </div>
               <div class="auth-privacy-policy">
                  <p class="description"><?php echo e(__("By clicking Login, you agree to our")); ?> <a class="link" href="<?php echo e(url('/terms-and-conditions')); ?>"> Terms & Condition</a> <span>and</span> <a class="link" href="<?php echo e(url('/privacy-policy')); ?>"> Privacy Policy</a></p>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<!-- Sign in area end -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<?php if($googleReCaptcha): ?>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
   $(document).ready(function() {
      $('.eyeicon').on('click', function() {
         let passwordInput = $(this).siblings('.password-input');
         let icon = $(this).find('i');

         if (passwordInput.attr('type') === 'password') {
            passwordInput.attr('type', 'text');
            icon.removeClass('fa-eye-slash').addClass('fa-eye');
         } else {
            passwordInput.attr('type', 'password');
            icon.removeClass('fa-eye').addClass('fa-eye-slash');
         }
      });
   });
</script>
<?php echo $__env->make('frontend::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ekobitt/public_html/app/Providers/../../resources/views/frontend/coinefy/auth/login.blade.php ENDPATH**/ ?>