<div
    class="modal fade"
    id="addNewRanking"
    tabindex="-1"
    aria-labelledby="addNewRankingModalLabel"
    aria-hidden="true"
>
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content site-table-modal">
            <div class="modal-body popup-body">
                <button
                    type="button"
                    class="btn-close"
                    data-bs-dismiss="modal"
                    aria-label="Close"
                ></button>
                <div class="popup-body-text">
                    <h3 class="title mb-4"><?php echo e(__('Add New Ranking')); ?></h3>
                    <form action="<?php echo e(route('admin.ranking.store')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="site-input-groups mb-2">
                            <label class="box-input-label" for=""><?php echo e(__('Ranking Icon:')); ?></label>
                            <div class="wrap-custom-file">
                                <input type="file" name="icon" id="icon" accept=".gif, .jpg, .png"/>
                                <label for="icon">
                                    <img class="upload-icon" src="<?php echo e(asset('global/materials/upload.svg')); ?>" alt=""/>
                                    <span><?php echo e(__('Upload Icon')); ?></span>
                                </label>
                            </div>
                        </div>


                        <div class="site-input-groups row mb-0">
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label for="" class="box-input-label"><?php echo e(__('Ranking:')); ?></label>
                                    <input type="text" name="ranking" value="<?php echo e(old('ranking')); ?>"
                                           class="box-input mb-0"
                                           placeholder="Eg: 1, 2, 3..." required=""/>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label for="" class="box-input-label"><?php echo e(__('Ranking Name:')); ?></label>
                                    <input type="text" name="ranking_name" value="<?php echo e(old('ranking_name')); ?>"
                                           class="box-input mb-0" placeholder="Ranking Name" required=""/>
                                </div>
                            </div>
                        </div>

                        <div class="site-input-groups row mb-0">
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label for="" class="box-input-label"><?php echo e(__('Minimum Deposit:')); ?></label>
                                    <div class="input-group joint-input">
                                        <input type="text" class="form-control" name="minimum_deposit"
                                               oninput="this.value = validateDouble(this.value)">
                                        <span class="input-group-text"><?php echo e(setting('site_currency','global')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label for="" class="box-input-label"><?php echo e(__('Minimum Invest:')); ?></label>
                                    <div class="input-group joint-input">
                                        <input type="text" class="form-control" name="minimum_invest"
                                               oninput="this.value = validateDouble(this.value)">
                                        <span class="input-group-text"><?php echo e(setting('site_currency','global')); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="site-input-groups row mb-0">
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label for="" class="box-input-label"><?php echo e(__('Minimum Referral:')); ?></label>
                                    <input type="text" name="minimum_referral" value="<?php echo e(old('minimum_referral')); ?>"
                                           oninput="this.value = validateDouble(this.value)"
                                           class="box-input mb-0" required=""/>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label for="" class="box-input-label"><?php echo e(__('Minimum Referral Deposit:')); ?></label>
                                    <div class="input-group joint-input">
                                        <input type="text" class="form-control" name="minimum_referral_deposit"
                                               oninput="this.value = validateDouble(this.value)">
                                        <span class="input-group-text"><?php echo e(setting('site_currency','global')); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="site-input-groups row mb-0">
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label for="" class="box-input-label"><?php echo e(__('Minimum Referral Invest:')); ?></label>
                                    <div class="input-group joint-input">
                                        <input type="text" class="form-control" name="minimum_referral_invest"
                                               oninput="this.value = validateDouble(this.value)">
                                        <span class="input-group-text"><?php echo e(setting('site_currency','global')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label for="" class="box-input-label"><?php echo e(__('Minimum Earning:')); ?></label>
                                    <div class="input-group joint-input">
                                        <input type="text" class="form-control" name="minimum_earnings"
                                               oninput="this.value = validateDouble(this.value)">
                                        <span class="input-group-text"><?php echo e(setting('site_currency','global')); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="site-input-groups">
                            <label for="" class="box-input-label"><?php echo e(__('Bonus:')); ?></label>
                            <div class="input-group joint-input">
                                <input type="text" class="form-control" name="bonus"
                                       oninput="this.value = validateDouble(this.value)">
                                <span class="input-group-text"><?php echo e(setting('site_currency','global')); ?></span>
                            </div>
                        </div>

                        <div class="site-input-groups mb-0">
                            <label for="" class="box-input-label"><?php echo e(__('Description:')); ?></label>
                            <textarea name="description" class="form-textarea"
                                      placeholder="Description"><?php echo e(old('description')); ?></textarea>
                        </div>

                        <div class="site-input-groups mb-0">
                            <label class="box-input-label" for=""><?php echo e(__('Status:')); ?></label>
                            <div class="switch-field">
                                <input type="radio" id="radioRaningStatusActive" name="status" checked="" value="1">
                                <label for="radioRaningStatusActive"><?php echo e(__('Active')); ?></label>
                                <input type="radio" id="radioRaningStatusDisabled" name="status" value="0">
                                <label for="radioRaningStatusDisabled"><?php echo e(__('Disabled')); ?></label>
                            </div>
                        </div>

                        <div class="action-btns">
                            <button type="submit" class="site-btn-sm primary-btn me-2">
                                <i icon-name="check"></i>
                                <?php echo e(__('Add Ranking')); ?>

                            </button>
                            <a href="#" class="site-btn-sm red-btn" data-bs-dismiss="modal" aria-label="Close">
                                <i icon-name="x"></i>
                                <?php echo e(__('Close')); ?>

                            </a>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/ekobitt/public_html/resources/views/backend/ranking/include/__add_new.blade.php ENDPATH**/ ?>