<form action="<?php echo e(route('admin.navigation.menu.update')); ?>" method="post">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="id" id="manuId" value="<?php echo e($navigation->id); ?>">
    <h3 class="title mb-4"><?php echo e(__('Update Menu Item')); ?></h3>
    <div class="site-input-groups">
        <label for="" class="box-input-label"><?php echo e(__('Menu Name:')); ?></label>
        <input type="text" name="name" class="box-input mb-0 name" placeholder="Menu Name"
               value="<?php echo e($navigation->name); ?>" required=""/>
    </div>
    <div class="site-input-groups">
        <label for="" class="box-input-label"><?php echo e(__('Page:')); ?></label>
        <select name="select_page" class="form-select edit-page-select">
            <option value="">--<?php echo e(__('Select One')); ?>--</option>
            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option
                    <?php if( $page->id == $navigation->page_id ): echo 'selected'; endif; ?> value="<?php echo e($page->id); ?>"><?php echo e($page->title); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <option value="custom" <?php if( $navigation->page_id == null ): echo 'selected'; endif; ?> ><?php echo e(__('Custom Url')); ?></option>

        </select>
    </div>
    <div class="site-input-groups edit-custom-url-input <?php if($navigation->page_id): ?> hidden <?php endif; ?>">
        <label for="" class="box-input-label"><?php echo e(__('Custom URL:')); ?></label>
        <input type="text" name="custom_url" class="box-input mb-0 custom-url" placeholder="Custom URL"
               value="<?php echo e($navigation->url); ?>"/>
    </div>

    <div class="site-input-groups">
        <label for="" class="box-input-label"><?php echo e(__('Display In:')); ?></label>
        <select name="type" class="form-select type">
            <option
                value="header" <?php if( $navigation->type == \App\Enums\NavigationType::Header->value ): echo 'selected'; endif; ?>><?php echo e(__('Header')); ?></option>
            <option
                value="footer" <?php if( $navigation->type == \App\Enums\NavigationType::Footer->value ): echo 'selected'; endif; ?>><?php echo e(__('Footer')); ?></option>
            <option
                value="both" <?php if( $navigation->type == \App\Enums\NavigationType::Both->value ): echo 'selected'; endif; ?>><?php echo e(__('Header and Footer Both')); ?></option>
        </select>
    </div>

    <div class="site-input-groups">
        <label class="box-input-label" for=""><?php echo e(__('Status:')); ?></label>
        <div class="switch-field">
            <input type="radio" id="active<?php echo e($navigation->id); ?>" name="status" <?php if( $navigation->status): echo 'checked'; endif; ?> value="1">
            <label for="active<?php echo e($navigation->id); ?>"><?php echo e(__('Active')); ?></label>
            <input type="radio" id="disabled<?php echo e($navigation->id); ?>" name="status"
                   <?php if(!$navigation->status ): echo 'checked'; endif; ?> value="0">
            <label for="disabled<?php echo e($navigation->id); ?>"><?php echo e(__('Disabled')); ?></label>
        </div>
    </div>

    <div class="action-btns">
        <button type="submit" class="site-btn-sm primary-btn me-2">
            <i icon-name="check"></i>
            <?php echo e(__('Update Menu')); ?>

        </button>
        <a href="#" class="site-btn-sm red-btn" data-bs-dismiss="modal">
            <i icon-name="x"></i>
            <?php echo e(__('Close')); ?>

        </a>
    </div>
</form>
<?php /**PATH /home/ekobitt/public_html/resources/views/backend/navigation/include/__edit_section.blade.php ENDPATH**/ ?>