
<?php $__env->startSection('title'); ?>
<?php echo e($data->title); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_keywords'); ?>
<?php echo e($data['meta_keywords']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_description'); ?>
<?php echo e($data['meta_description']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-content'); ?>

<?php
$blogs = \App\Models\Blog::where('locale',app()->getLocale())->latest()->paginate(6);
?>

<!-- Blog area start -->
<div class="td-blog-area position-relative z-index-11 inner-pages_space-top fix section_space-bottom">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-5 col-xl-6 col-lg-8">
                <div class="section-title-wrapper text-center section_title_space">
                    <span class="section-subtitle"><?php echo e($data->title_big); ?></span>
                    <h2 class="section-title has_fade_anim mb-15"><?php echo e($data['blog_title_big']); ?></h2>
                </div>
            </div>
        </div>
        <div class="row gy-20">
            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6">
                <div class="has_fade_anim" data-fade-from="bottom" data-delay="0.30">
                    <article class="single-blog-item">
                        <div class="blog-thumb-box">
                            <div class="blog-thumb">
                                <a href="<?php echo e(route('blog-details',$blog->id)); ?>">
                                    <img src="<?php echo e(asset($blog->cover)); ?>" alt="blog img not found">
                                </a>
                            </div>
                            <div class="blog-date">
                                <span><?php echo e($blog->created_at); ?></span>
                            </div>
                        </div>
                        <div class="blog-contents">
                            <h5 class="title">
                                <a href="<?php echo e(route('blog-details',$blog->id)); ?>"><?php echo e($blog->title); ?></a>
                            </h5>
                            <p class="description"> <?php echo Str::limit($blog->details,100); ?></p>
                            <div class="blog-link">
                                <a class="btn-text" href="<?php echo e(route('blog-details',$blog->id)); ?>">Read More</a>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php echo e($blogs->links()); ?>

        </div>
    </div>
</div>
<!-- Blog area end -->

<!-- CTA section end -->
<?php
$landata = \App\Models\LandingPage::where('code', 'cta')
    ->where('locale', app()->getLocale())
    ->first();

$data = json_decode($landata['data'], true);
?>
<?php echo $__env->make('frontend::home.include.__cta',$data, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Cta section end -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend::pages.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ekobitt/public_html/app/Providers/../../resources/views/frontend/coin_orbit/pages/blog.blade.php ENDPATH**/ ?>