
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Reward Point Redeem')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Reward Point Redeem')); ?></h2>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reward-redeem-create')): ?>
                                <a href="" class="title-btn" type="button" data-bs-toggle="modal"
                                   data-bs-target="#addNewRedeem">
                                    <i data-lucide="plus-circle"></i><?php echo e(__('Add New')); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body">
                            <div class="site-table table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th scope="col"><?php echo e(__('Ranking')); ?></th>
                                        <th scope="col"><?php echo e(__('Per Point')); ?></th>
                                        <th scope="col"><?php echo e(__('Redeem Amount')); ?></th>
                                        <th scope="col"><?php echo e(__('Action')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $redeems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $redeem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>

                                            <td>
                                                <strong><?php echo e($redeem->ranking->ranking); ?></strong>
                                            </td>
                                            <td>
                                                <strong><?php echo e($redeem->point); ?></strong>
                                            </td>
                                            <td>
                                                <strong><?php echo e($currencySymbol.$redeem->amount); ?></strong>
                                            </td>
                                            <td>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reward-redeem-edit')): ?>
                                                    <button class="round-icon-btn primary-btn editBtn" type="button"
                                                            data-redeem="<?php echo e(json_encode($redeem)); ?>">
                                                        <i data-lucide="edit-3"></i>
                                                    </button>
                                                <?php endif; ?>

                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reward-redeem-delete')): ?>
                                                    <button class="round-icon-btn red-btn delete-btn" data-id="<?php echo e($redeem->id); ?>" type="button">
                                                        <i data-lucide="trash"></i>
                                                    </button>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <td colspan="8" class="text-center"><?php echo e(__('No Data Found!')); ?></td>
                                    <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal for Add New redeem -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reward-redeem-create')): ?>
            <?php echo $__env->make('backend.reward-point.redeem.include.__add_new', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Add New redeem-->

        <!-- Modal for Edit redeem -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reward-redeem-edit')): ?>
            <?php echo $__env->make('backend.reward-point.redeem.include.__edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Edit redeem-->

        <!-- Modal for Delete -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reward-redeem-delete')): ?>
            <?php echo $__env->make('backend.reward-point.redeem.include.__delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Delete Box End-->

    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>

        $('#ranking_id').select2({
            dropdownParent : $('#addNewRedeem'),
            minimumResultsForSearch: Infinity
        });

        $('.editBtn').on('click',function (e) {

            "use strict";

            e.preventDefault();
            var redeem = $(this).data('redeem');

            var url = '<?php echo e(route("admin.reward.point.redeem.update", ":id")); ?>';
            url = url.replace(':id', redeem.id);

            $('#redeemEditForm').attr('action', url);
            $('#edit_ranking_id').val(redeem.ranking_id);
            $('.amount').val(redeem.amount);
            $('.point').val(redeem.point);

            $('#edit_ranking_id').select2({
                dropdownParent : $('#editRedeem'),
                minimumResultsForSearch: Infinity
            });

            $('#editRedeem').modal('show');
        });

        $('.delete-btn').on('click',function(){

            var url = '<?php echo e(route("admin.reward.point.redeem.destroy", ":id")); ?>';
            url = url.replace(':id',$(this).attr('data-id'));

            $('#delete-form').attr('action',url);
            $('#deleteModal').modal('show');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ekobitt/public_html/resources/views/backend/reward-point/redeem/index.blade.php ENDPATH**/ ?>