<?php
    $landingContent = \App\Models\LandingContent::where('type', 'whychooseus')
        ->where('locale', app()->getLocale())
        ->get();
?>

<section class="rock-why-choose-section section-space-top">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-8 ciol-xl-6 col-lg-6">
                <div class="section-title-wrapper-four text-center section-title-space">
                    <span class="subtitle-four"><?php echo e($data['title_small']); ?></span>
                    <h2 class="section-title-four"><?php echo e($data['title_big']); ?></span>
                    </h2>
                </div>
            </div>
            <div class="rock-why-choose-grid">
                <?php $__currentLoopData = $landingContent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="rock-why-choose-item">
                        <div class="icon theme-bg-dark">
                            <span>
                                <?php if(content_exists($content->icon)): ?>
                                    <img src="<?php echo e(asset($content->icon)); ?>">
                                <?php else: ?>
                                    <i class="<?php echo e($content->icon); ?>"> </i>
                                <?php endif; ?>
                            </span>
                        </div>
                        <div class="content">
                            <h3 class="title"><?php echo e($content->title); ?></h3>
                            <p class="description">
                                <?php echo e($content->description); ?>

                            </p>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/ekobitt/public_html/app/Providers/../../resources/views/frontend/investify/home/include/__whychooseus.blade.php ENDPATH**/ ?>