
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Page Settings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Page Settings')); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12">
                    <div class="site-card">
                        <div class="site-card-header">
                            <h3 class="title"><?php echo e(__('Basic Settings')); ?></h3>
                        </div>
                        <div class="site-card-body">
                            <form action="<?php echo e(route('admin.page.setting.update')); ?>" method="post"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="site-input-groups row">
                                    <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 col-label">
                                        <?php echo e(__('Page Breadcrumb')); ?><i icon-name="info" data-bs-toggle="tooltip"
                                            title=""
                                            data-bs-original-title="All the pages Breadcrumb Background Image"></i>
                                    </div>
                                    <div class="col-xl-9 col-lg-9 col-md-9 col-sm-12">
                                        <div class="wrap-custom-file">
                                            <input type="file" name="breadcrumb" id="breadcrumbBg"
                                                accept=".gif, .jpg, .png" />
                                            <label for="breadcrumbBg" class="file-ok"
                                                style="background-image: url(<?php echo e(asset(getPageSetting('breadcrumb'))); ?>)">
                                                <img class="upload-icon" src="<?php echo e(asset('global/materials/upload.svg')); ?>"
                                                    alt="" />
                                                <span><?php echo e(__('Update Background')); ?></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="offset-sm-3 col-sm-9">
                                        <button type="submit"
                                            class="site-btn-sm primary-btn"><?php echo e(__('Save Changes')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12">
                    <div class="site-card">
                        <div class="site-card-header">
                            <h3 class="title"><?php echo e(__('Register Field Settings')); ?></h3>
                        </div>
                        <div class="site-card-body">
                            <form action="<?php echo e(route('admin.page.setting.update')); ?>" method="post"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>

                                <div class="site-input-groups row">
                                    <div class="col-sm-3 col-label"><?php echo e(__('Manage Fields for Registration')); ?></div>
                                    <div class="col-sm-9">
                                        <div class="form-row">
                                            <div class="col-xl-6 col-sm-12 col-12">
                                                <div class="site-input-groups">
                                                    <label class="box-input-label"
                                                        for=""><?php echo e(__('Username:')); ?></label>
                                                    <div class="switch-field">
                                                        <input type="radio" id="username-show" name="username_show"
                                                            <?php if(getPageSetting('username_show')): echo 'checked'; endif; ?> value="1" />
                                                        <label for="username-show"><?php echo e(__('Show')); ?></label>
                                                        <input type="radio" id="username-hide" name="username_show"
                                                            <?php if(!getPageSetting('username_show')): echo 'checked'; endif; ?> value="0" />
                                                        <label for="username-hide"><?php echo e(__('Hide')); ?></label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-6 col-sm-12 col-12">
                                                <div class="site-input-groups">
                                                    <label class="box-input-label"
                                                        for=""><?php echo e(__('Phone Number:')); ?></label>
                                                    <div class="switch-field">
                                                        <input type="radio" id="phone-show" name="phone_show"
                                                            <?php if(getPageSetting('phone_show')): echo 'checked'; endif; ?> value="1" />
                                                        <label for="phone-show"><?php echo e(__('Show')); ?></label>
                                                        <input type="radio" id="phone-hide" name="phone_show"
                                                            <?php if(!getPageSetting('phone_show')): echo 'checked'; endif; ?> value="0" />
                                                        <label for="phone-hide"><?php echo e(__('Hide')); ?></label>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="form-row">
                                            <div class="col-xl-6 col-sm-12 col-12">
                                                <div class="site-input-groups">
                                                    <label class="box-input-label"
                                                        for=""><?php echo e(__('Country:')); ?></label>
                                                    <div class="switch-field">
                                                        <input type="radio" id="country-show" name="country_show"
                                                            <?php if(getPageSetting('country_show')): echo 'checked'; endif; ?> value="1" />
                                                        <label for="country-show"><?php echo e(__('Show')); ?></label>
                                                        <input type="radio" id="country-hide" name="country_show"
                                                            <?php if(!getPageSetting('country_show')): echo 'checked'; endif; ?> value="0" />
                                                        <label for="country-hide"><?php echo e(__('Hide')); ?></label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-6 col-sm-12 col-12">
                                                <div class="site-input-groups">
                                                    <label class="box-input-label"
                                                        for=""><?php echo e(__('Referral Code:')); ?></label>
                                                    <div class="switch-field">
                                                        <input type="radio" id="referral-code-show"
                                                            name="referral_code_show" <?php if(getPageSetting('referral_code_show')): echo 'checked'; endif; ?>
                                                            value="1" />
                                                        <label for="referral-code-show"><?php echo e(__('Show')); ?></label>
                                                        <input type="radio" id="referral-code-hide"
                                                            name="referral_code_show" <?php if(!getPageSetting('referral_code_show')): echo 'checked'; endif; ?>
                                                            value="0" />
                                                        <label for="referral-code-hide"><?php echo e(__('Hide')); ?></label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-12 col-sm-12 col-12">
                                                <a href="javascript:void(0)" id="generate"
                                                    class="site-btn-xs primary-btn mb-3"><?php echo e(__('Add Field option')); ?></a>

                                                <div class="addOptions">
                                                    <?php $__currentLoopData = json_decode(getPageSetting('register_custom_fields'), true) ?: []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="mb-4">
                                                            <div class="option-remove-row row">
                                                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                                                    <div class="site-input-groups">
                                                                        <input
                                                                            name="register_custom_fields[<?php echo e($key); ?>][name]"
                                                                            class="box-input" type="text"
                                                                            value="<?php echo e($value['name']); ?>" required
                                                                            placeholder="Field Name">
                                                                    </div>
                                                                </div>

                                                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                                                    <div class="site-input-groups">
                                                                        <select
                                                                            name="register_custom_fields[<?php echo e($key); ?>][type]"
                                                                            class="form-select form-select-lg mb-3">
                                                                            <option value="text"
                                                                                <?php if($value['type'] == 'text'): ?> selected <?php endif; ?>>
                                                                                <?php echo e(__('Input Text')); ?></option>
                                                                            <option value="textarea"
                                                                                <?php if($value['type'] == 'textarea'): ?> selected <?php endif; ?>>
                                                                                <?php echo e(__('Textarea')); ?></option>
                                                                            <option value="file"
                                                                                <?php if($value['type'] == 'file'): ?> selected <?php endif; ?>>
                                                                                <?php echo e(__('File upload')); ?></option>
                                                                            <option value="camera"
                                                                                <?php if($value['type'] == 'camera'): ?> selected <?php endif; ?>>
                                                                                <?php echo e(__('Camera')); ?></option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                                                                    <div class="site-input-groups mb-0">
                                                                        <select
                                                                            name="register_custom_fields[<?php echo e($key); ?>][validation]"
                                                                            class="form-select form-select-lg mb-1">
                                                                            <option value="required"
                                                                                <?php if($value['validation'] == 'required'): ?> selected <?php endif; ?>>
                                                                                <?php echo e(__('Required')); ?></option>
                                                                            <option value="nullable"
                                                                                <?php if($value['validation'] == 'nullable'): ?> selected <?php endif; ?>>
                                                                                <?php echo e(__('Optional')); ?></option>
                                                                        </select>
                                                                    </div>
                                                                </div>

                                                                <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                                                                    <button class="delete-option-row delete_desc"
                                                                        type="button">
                                                                        <i class="fas fa-times"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 col-sm-9">
                                        <button type="submit"
                                            class="site-btn-sm primary-btn"><?php echo e(__('Save Changes')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function(e) {
            "use strict";
            var i = Date.now();

            $("#generate").on('click', function() {
                i = Date.now();
                var form = `<div class="mb-4">
                  <div class="option-remove-row row">
                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                      <div class="site-input-groups">
                        <input name="register_custom_fields[` + i + `][name]" class="box-input" type="text" value="" required placeholder="Field Name">
                      </div>
                    </div>

                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                      <div class="site-input-groups">
                        <select name="register_custom_fields[` + i + `][type]" class="form-select form-select-lg mb-3">
                            <option value="text">Input Text</option>
                            <option value="textarea">Textarea</option>
                            <option value="file">File upload</option>
                            <option value="camera">Camera</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                      <div class="site-input-groups">
                        <select name="register_custom_fields[` + i + `][validation]" class="form-select form-select-lg mb-3">
                            <option value="required">Required</option>
                            <option value="nullable">Optional</option>
                        </select>
                      </div>
                    </div>

                    <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                      <button class="delete-option-row delete_desc" type="button">
                        <i class="fas fa-times"></i>
                      </button>
                    </div>
                    </div>
                  </div>`;
                $('.addOptions').append(form)
            });

            $(document).on('click', '.delete_desc', function() {
                $(this).closest('.option-remove-row').parent().remove();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ekobitt/public_html/resources/views/backend/page/setting.blade.php ENDPATH**/ ?>