
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Reward Point Earnings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Reward Point Earnings')); ?></h2>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reward-earning-create')): ?>
                                <a href="" class="title-btn" type="button" data-bs-toggle="modal"
                                   data-bs-target="#addNewEarning">
                                    <i data-lucide="plus-circle"></i><?php echo e(__('Add New')); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body">
                            <div class="site-table table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th scope="col"><?php echo e(__('Ranking')); ?></th>
                                        <th scope="col"><?php echo e(__('Amount Of Transactions')); ?></th>
                                        <th scope="col"><?php echo e(__('Reward Point')); ?></th>
                                        <th scope="col"><?php echo e(__('Action')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $earnings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $earning): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>

                                            <td>
                                                <strong><?php echo e($earning->ranking->ranking); ?></strong>
                                            </td>
                                            <td>
                                                <strong><?php echo e($currencySymbol.$earning->amount_of_transactions); ?></strong>
                                            </td>
                                            <td>
                                                <strong><?php echo e($earning->point); ?></strong>
                                            </td>
                                            <td>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reward-earning-edit')): ?>
                                                    <button class="round-icon-btn primary-btn editBtn" type="button"
                                                            data-earning="<?php echo e(json_encode($earning)); ?>">
                                                        <i data-lucide="edit-3"></i>
                                                    </button>
                                                <?php endif; ?>

                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reward-earning-delete')): ?>
                                                    <button class="round-icon-btn red-btn delete-btn" data-id="<?php echo e($earning->id); ?>" type="button">
                                                        <i data-lucide="trash"></i>
                                                    </button>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <td colspan="8" class="text-center"><?php echo e(__('No Data Found!')); ?></td>
                                    <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal for Add New Earning -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reward-earning-create')): ?>
            <?php echo $__env->make('backend.reward-point.earning.include.__add_new', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Add New Earning-->

        <!-- Modal for Edit Earning -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reward-earning-edit')): ?>
            <?php echo $__env->make('backend.reward-point.earning.include.__edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Edit Earning-->

        <!-- Modal for Delete -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reward-earning-delete')): ?>
            <?php echo $__env->make('backend.reward-point.earning.include.__delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Delete Box End-->

    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>

        $('#ranking_id').select2({
            dropdownParent : $('#addNewEarning'),
            minimumResultsForSearch: Infinity
        });

        $('.editBtn').on('click',function (e) {

            "use strict";

            e.preventDefault();
            var earning = $(this).data('earning');

            var url = '<?php echo e(route("admin.reward.point.earnings.update", ":id")); ?>';
            url = url.replace(':id', earning.id);

            $('#earningEditForm').attr('action', url);
            $('#edit_ranking_id').val(earning.ranking_id);
            $('.amount-of-transactions').val(earning.amount_of_transactions);
            $('.point').val(earning.point);

            $('#edit_ranking_id').select2({
                dropdownParent : $('#editEarning'),
                minimumResultsForSearch: Infinity
            });

            $('#editEarning').modal('show');
        });

        $('.delete-btn').on('click',function(){

            var url = '<?php echo e(route("admin.reward.point.earnings.destroy", ":id")); ?>';
            url = url.replace(':id',$(this).attr('data-id'));

            $('#delete-form').attr('action',url);
            $('#deleteModal').modal('show');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ekobitt/public_html/resources/views/backend/reward-point/earning/index.blade.php ENDPATH**/ ?>