<?php
$landingContent =\App\Models\LandingContent::where('type','counter')->where('locale',app()->getLocale())->get();
?>

<!-- Counter section start -->
<section class="counter-section section-space-bottom p-relative z-index:15">
    <div class="container">
        <div class="counter-main-wrapper">
            <div class="counter-item-grid">
                <?php $__currentLoopData = $landingContent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="counter-item">
                    <div class="counter-content">
                        <div class="icon">
                            <span>
                                <img src="<?php echo e(asset($content->icon)); ?>" alt="counter">
                            </span>
                        </div>
                        <p class="description"><?php echo e($content->title); ?></p>
                        <h3 class="title">
                            <?php
                                $description = $content->description;
                                if ($description >= 1000000000) {
                                    $formattedDescription = round($description / 1000000000, 1) . 'B+';
                                } elseif ($description >= 1000000) {
                                    $formattedDescription = round($description / 1000000, 1) . 'M+';
                                } elseif ($description >= 1000) {
                                    $formattedDescription = round($description / 1000, 1) . 'K+';
                                } else {
                                    $formattedDescription = number_format($description);
                                }
                            ?>
                            <span class=""><?php echo e($formattedDescription); ?></span>
                        </h3>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="coin-one">
                <img src="<?php echo e(asset('frontend/theme_base/coinefy/images/counter/counter-coin-01.png')); ?>" alt="counter coin">
            </div>
            <div class="coin-two">
                <img src="<?php echo e(asset('frontend/theme_base/coinefy/images/counter/counter-coin-02.png')); ?>" alt="counter coin">
            </div>
            <div class="coin-three">
                <img src="<?php echo e(asset('frontend/theme_base/coinefy/images/counter/counter-coin-03.png')); ?>" alt="counter coin">
            </div>
            <div class="coin-four">
                <img src="<?php echo e(asset('frontend/theme_base/coinefy/images/counter/counter-coin-04.png')); ?>" alt="counter coin">
            </div>
            <div class="counter-glow">
                <img src="<?php echo e(asset('frontend/theme_base/coinefy/images/counter/counter-glow.png')); ?>" alt="">
            </div>
        </div>
    </div>
</section>
<!-- Counter section end --><?php /**PATH /home/ekobitt/public_html/app/Providers/../../resources/views/frontend/coinefy/home/include/__counter.blade.php ENDPATH**/ ?>