
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Set Target')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-xl-8">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Set Referral Target')); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-md-12">
                    <div class="site-card">
                        <div class="site-card-header">
                            <h3 class="title"><?php echo e(__('List of Targets')); ?></h3>
                            <div class="card-header-links">
                                <a href="" class="card-header-link" type="button" data-bs-toggle="modal"
                                   data-bs-target="#addNewTarget"><?php echo e(__('Add New')); ?></a>
                            </div>
                        </div>
                        <div class="site-card-body">
                            <p class="paragraph"><i icon-name="alert-triangle"></i><?php echo e(__('You can')); ?>

                                <strong><?php echo e(__('Add or Edit')); ?></strong> <?php echo e(__('any of the')); ?>

                                <strong><?php echo e(__('Targets')); ?></strong></p>
                            <?php $__currentLoopData = $targets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $target): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="single-gateway">
                                    <div class="gateway-name">
                                        <div class="gateway-title">
                                            <h4><?php echo e($target->name); ?></h4>
                                        </div>
                                    </div>
                                    <div class="gateway-right">
                                        <div class="gateway-edit">
                                            <a href="#" type="button" class="edit-target" data-id="<?php echo e($target->id); ?>"
                                               data-name="<?php echo e($target->name); ?>"><i icon-name="edit-3"></i></a>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal for Add New Target -->
        <?php echo $__env->make('backend.referral.include.__new_target', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Modal for Add New Target-->

        <!-- Modal for Edit Target -->
        <?php echo $__env->make('backend.referral.include.__edit_target', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Modal for Edit Target-->

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $('.edit-target').on('click', function (e) {
            "use strict";
            e.preventDefault();
            var id = $(this).data('id');
            var name = $(this).data('name');

            $('#target-id').val(id);
            $('.target-name').val(name);
            $('#editTarget').modal('show');

        })


    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ekobitt/public_html/resources/views/backend/referral/target.blade.php ENDPATH**/ ?>