
<?php $__env->startSection('title'); ?>
<?php echo e($data['title']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_keywords'); ?>
<?php echo e($data['meta_keywords']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_description'); ?>
<?php echo e($data['meta_description']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-content'); ?>
<?php
$schemas = \App\Models\Schema::where('status',true)->with('schedule')->get();
?>

<!-- Investment Plan section start -->
<section class="investment-plan-section p-relative z-index-11 section-space-top">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-5 col-xl-6 col-lg-6">
                <div class="section-heading section-title-space text-center">
                    <span class="section-subtitle"><?php echo e($data['title_small']); ?></span>
                    <h2 class="section-title"><?php echo e($data['title_big']); ?></h2>
                </div>
            </div>
        </div>
        <div class="row gx-0 gy-30">
            <?php $__currentLoopData = $schemas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schema): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6">
                <div class="investment-item <?php if($schema->featured): ?> plan-active <?php endif; ?>">
                    <div class="investment-heading">
                        <h3 class="title"><?php echo e($schema->name); ?></h3>
                        <?php if($schema->interest_type == 'fixed'): ?>
                            <span class="info-badge">
                                <?php echo e($schema->schedule->name . ' '); ?>

                                <?php echo e($schema->roi_interest_type == 'percentage' ? $schema->fixed_roi . '%' : '$' . $schema->fixed_roi); ?>

                            </span>
                        <?php else: ?>
                            <span class="info-badge">
                                <?php echo e($schema->schedule->name . ' '); ?>

                                <?php echo e($schema->roi_interest_type == 'percentage'
                                    ? $schema->min_roi . '%' . ' - ' . $schema->max_roi . '%'
                                    : '$' . $schema->min_roi . ' - $' . $schema->max_roi); ?>

                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="investment-plan-list">
                        <ul>
                            <li>
                                <div class="investment-plan-content-list">
                                    <span class="price-info"><?php echo e($schema->type == 'range' ? $currencySymbol . $schema->min_amount . '-' . $currencySymbol . $schema->max_amount : $currencySymbol . $schema->fixed_amount); ?></span>
                                    <div class="list-info">
                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.4" d="M3.33366 6.6665H1.66699V14.1665L5.25935 15.9627C6.18506 16.4255 7.20581 16.6665 8.24078 16.6665H15.0003C15.9208 16.6665 16.667 15.9203 16.667 14.9998C16.667 14.0794 15.9208 13.3332 15.0003 13.3332H13.6807C12.9044 13.3332 12.1389 13.1524 11.4446 12.8053L8.99365 11.5798C9.15391 11.4323 9.2863 11.2492 9.37767 11.036C9.72231 10.2319 9.35373 9.30029 8.5522 8.94961L3.33366 6.6665Z" fill="white" />
                                            <path d="M10.507 7.09195L12.6049 9.71441C13.4056 10.7152 14.9278 10.7152 15.7284 9.71441L17.8264 7.09195C18.1545 6.68174 18.3333 6.17205 18.3333 5.64673V5.54296C18.3333 4.32257 17.344 3.33325 16.1236 3.33325H15.8758C15.4484 3.33325 15.0386 3.50302 14.7364 3.80521C14.4217 4.11985 13.9116 4.11985 13.597 3.80521C13.2948 3.50302 12.8849 3.33325 12.4575 3.33325H12.2097C10.9893 3.33325 10 4.32257 10 5.54296V5.64673C10 6.17205 10.1788 6.68174 10.507 7.09195Z" fill="white" />
                                        </svg>
                                        <span><?php echo e(__('Investment')); ?></span>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="investment-plan-content-list">
                                    <span class="price-info"><?php echo e($schema->capital_back ? __('Yes') : __('No')); ?></span>
                                    <div class="list-info">
                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.4" d="M2.52777 8.33341L17.4729 8.33341C18.323 8.33341 18.6568 7.20723 17.9495 6.72557L10.9535 1.96154C10.3763 1.56848 9.62434 1.56848 9.04714 1.96154L2.05117 6.72557C1.34386 7.20723 1.67768 8.33341 2.52777 8.33341Z" fill="white" />
                                            <rect x="5" y="8.3335" width="3.33333" height="6.66667" fill="white" />
                                            <rect x="11.667" y="8.3335" width="3.33333" height="6.66667" fill="white" />
                                            <path opacity="0.4" d="M16.1516 15C16.4672 15 16.7558 15.1783 16.8969 15.4607L17.7303 17.1273C18.0073 17.6814 17.6044 18.3333 16.9849 18.3333L3.01498 18.3333C2.3955 18.3333 1.99259 17.6814 2.26963 17.1273L3.10296 15.4607C3.24412 15.1783 3.53267 15 3.84832 15L16.1516 15Z" fill="white" />
                                        </svg>
                                        <span><?php echo e(__('Capital Back')); ?></span>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="investment-plan-content-list">
                                    <span class="price-info"><?php echo e(__(ucwords($schema->return_type))); ?></span>
                                    <div class="list-info">
                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.4" d="M3.33366 6.6665H1.66699V14.1665L5.25935 15.9627C6.18506 16.4255 7.20581 16.6665 8.24078 16.6665H15.0003C15.9208 16.6665 16.667 15.9203 16.667 14.9998C16.667 14.0794 15.9208 13.3332 15.0003 13.3332H13.6807C12.9044 13.3332 12.1389 13.1524 11.4446 12.8053L8.99365 11.5798C9.15391 11.4323 9.2863 11.2492 9.37767 11.036C9.72231 10.2319 9.35373 9.30029 8.5522 8.94961L3.33366 6.6665Z" fill="white" />
                                            <path d="M10.507 7.09195L12.6049 9.71441C13.4056 10.7152 14.9278 10.7152 15.7284 9.71441L17.8264 7.09195C18.1545 6.68174 18.3333 6.17205 18.3333 5.64673V5.54296C18.3333 4.32257 17.344 3.33325 16.1236 3.33325H15.8758C15.4484 3.33325 15.0386 3.50302 14.7364 3.80521C14.4217 4.11985 13.9116 4.11985 13.597 3.80521C13.2948 3.50302 12.8849 3.33325 12.4575 3.33325H12.2097C10.9893 3.33325 10 4.32257 10 5.54296V5.64673C10 6.17205 10.1788 6.68174 10.507 7.09195Z" fill="white" />
                                        </svg>
                                        <span><?php echo e(__('Return Type')); ?></span>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="investment-plan-content-list">
                                    <span class="price-info"><?php echo e(($schema->return_type == 'period' ? $schema->number_of_period.' ' : __('Unlimited').' ' )); ?>


                                        <?php if(($schema->number_of_period == 1 && $schema->return_type == 'period')): ?>
                                        <?php echo e(__('Time')); ?>

                                        <?php elseif($schema->return_type == 'period'): ?>
                                        <?php echo e(__('Times')); ?>

                                        <?php endif; ?></span>
                                    <div class="list-info">
                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.4" d="M3.33366 6.6665H1.66699V14.1665L5.25935 15.9627C6.18506 16.4255 7.20581 16.6665 8.24078 16.6665H15.0003C15.9208 16.6665 16.667 15.9203 16.667 14.9998C16.667 14.0794 15.9208 13.3332 15.0003 13.3332H13.6807C12.9044 13.3332 12.1389 13.1524 11.4446 12.8053L8.99365 11.5798C9.15391 11.4323 9.2863 11.2492 9.37767 11.036C9.72231 10.2319 9.35373 9.30029 8.5522 8.94961L3.33366 6.6665Z" fill="white" />
                                            <path d="M10.507 7.09195L12.6049 9.71441C13.4056 10.7152 14.9278 10.7152 15.7284 9.71441L17.8264 7.09195C18.1545 6.68174 18.3333 6.17205 18.3333 5.64673V5.54296C18.3333 4.32257 17.344 3.33325 16.1236 3.33325H15.8758C15.4484 3.33325 15.0386 3.50302 14.7364 3.80521C14.4217 4.11985 13.9116 4.11985 13.597 3.80521C13.2948 3.50302 12.8849 3.33325 12.4575 3.33325H12.2097C10.9893 3.33325 10 4.32257 10 5.54296V5.64673C10 6.17205 10.1788 6.68174 10.507 7.09195Z" fill="white" />
                                        </svg>
                                        <span><?php echo e(__('Periods')); ?></span>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="investment-plan-content-list">
                                    <span class="price-info"><?php echo e(__('Anytime')); ?></span>
                                    <div class="list-info">
                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.4" d="M3.33366 6.6665H1.66699V14.1665L5.25935 15.9627C6.18506 16.4255 7.20581 16.6665 8.24078 16.6665H15.0003C15.9208 16.6665 16.667 15.9203 16.667 14.9998C16.667 14.0794 15.9208 13.3332 15.0003 13.3332H13.6807C12.9044 13.3332 12.1389 13.1524 11.4446 12.8053L8.99365 11.5798C9.15391 11.4323 9.2863 11.2492 9.37767 11.036C9.72231 10.2319 9.35373 9.30029 8.5522 8.94961L3.33366 6.6665Z" fill="white" />
                                            <path d="M10.507 7.09195L12.6049 9.71441C13.4056 10.7152 14.9278 10.7152 15.7284 9.71441L17.8264 7.09195C18.1545 6.68174 18.3333 6.17205 18.3333 5.64673V5.54296C18.3333 4.32257 17.344 3.33325 16.1236 3.33325H15.8758C15.4484 3.33325 15.0386 3.50302 14.7364 3.80521C14.4217 4.11985 13.9116 4.11985 13.597 3.80521C13.2948 3.50302 12.8849 3.33325 12.4575 3.33325H12.2097C10.9893 3.33325 10 4.32257 10 5.54296V5.64673C10 6.17205 10.1788 6.68174 10.507 7.09195Z" fill="white" />
                                        </svg>
                                        <span><?php echo e(__('Profit withdraw')); ?></span>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="investment-plan-content-list">
                                    <span class="price-info"><?php if($schema->schema_cancel): ?>
                                        <?php echo e(__('In').' '. $schema->expiry_minute .' '. ($schema->expiry_minute == 1 ? __('Minute') : __('Minutes'))); ?>

                                        <?php else: ?>
                                        <?php echo e(__('No')); ?>

                                        <?php endif; ?></span>
                                    <div class="list-info">
                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.4" d="M12.357 5.28552C13.0079 4.63464 14.0631 4.63464 14.714 5.28552C15.3649 5.93639 15.3649 6.99167 14.714 7.64254L7.64294 14.7136C6.99206 15.3645 5.93679 15.3645 5.28592 14.7136C4.63504 14.0627 4.63504 13.0075 5.28592 12.3566L12.357 5.28552Z" fill="white" />
                                            <path d="M14.714 12.3566C15.3649 13.0075 15.3649 14.0627 14.714 14.7136C14.0631 15.3645 13.0079 15.3645 12.357 14.7136L5.28592 7.64254C4.63504 6.99167 4.63504 5.93639 5.28592 5.28552C5.93679 4.63464 6.99206 4.63464 7.64294 5.28552L14.714 12.3566Z" fill="white" />
                                        </svg>
                                        <span><?php echo e(__('Cancel')); ?></span>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>

                    <div class="btn-inner">
                        <span class="short-info">* <?php if( null != $schema->off_days): ?>
                            <?php echo e(implode(', ', json_decode($schema->off_days,true))  .' '.__('are')); ?>

                            <?php else: ?>
                            <?php echo e(__('No Profit')); ?>

                            <?php endif; ?> <?php echo e(__('Holidays')); ?>

                        </span>
                        <a class="shape-shifter-btn primary-btn" href="<?php echo e(route('user.schema.preview',$schema->id)); ?>">
                            <div class="btn-hover-slide">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.4" d="M17 7.75C16.81 7.75 16.62 7.68 16.47 7.53C16.18 7.24 16.18 6.76 16.47 6.47L18.52 4.42C16.76 2.92 14.49 2 12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 9.51 21.08 7.24 19.58 5.48L17.53 7.53C17.38 7.68 17.19 7.75 17 7.75Z" fill="white" />
                                    <path d="M13.75 11.82L12.75 11.47V9.25H12.83C13.34 9.25 13.75 9.7 13.75 10.25C13.75 10.66 14.09 11 14.5 11C14.91 11 15.25 10.66 15.25 10.25C15.25 8.87 14.17 7.75 12.83 7.75H12.75V7.5C12.75 7.09 12.41 6.75 12 6.75C11.59 6.75 11.25 7.09 11.25 7.5V7.75H10.95C9.74001 7.75 8.75 8.77 8.75 10.03C8.75 11.49 9.6 11.96 10.25 12.19L11.25 12.54V14.76H11.17C10.66 14.76 10.25 14.31 10.25 13.76C10.25 13.35 9.91 13.01 9.5 13.01C9.09 13.01 8.75 13.35 8.75 13.76C8.75 15.14 9.83001 16.26 11.17 16.26H11.25V16.51C11.25 16.92 11.59 17.26 12 17.26C12.41 17.26 12.75 16.92 12.75 16.51V16.26H13.05C14.26 16.26 15.25 15.24 15.25 13.98C15.25 12.51 14.4 12.04 13.75 11.82ZM10.74 10.76C10.4 10.64 10.25 10.57 10.25 10.02C10.25 9.59 10.57 9.24 10.95 9.24H11.25V10.93L10.74 10.76ZM13.05 14.75H12.75V13.06L13.26 13.24C13.6 13.36 13.75 13.43 13.75 13.98C13.75 14.4 13.43 14.75 13.05 14.75Z" fill="white" />
                                    <path d="M22.6922 1.71024C22.6122 1.53024 22.4722 1.38024 22.2822 1.30024C22.1922 1.26024 22.0922 1.24023 21.9922 1.24023H17.9922C17.5822 1.24023 17.2422 1.58023 17.2422 1.99023C17.2422 2.40023 17.5822 2.74023 17.9922 2.74023H20.1822L18.5122 4.41024C18.8922 4.74024 19.2422 5.09024 19.5722 5.47024L21.2422 3.80024V6.00024C21.2422 6.41024 21.5822 6.75024 21.9922 6.75024C22.4022 6.75024 22.7422 6.41024 22.7422 6.00024V2.00024C22.7522 1.90024 22.7322 1.81024 22.6922 1.71024Z" fill="white" />
                                </svg>
                                <?php echo e(__('Invest Now')); ?>

                            </div>
                        </a>
                    </div>
                    <div class="plan-active">
                        <div class="shape-star">
                            <img src="<?php echo e(asset('frontend/theme_base/coinefy/images/icons/star.png')); ?>" alt="star">
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <div class="investment-plan-bg" data-background="<?php echo e(asset('images/bg/investment-plan-bg.png')); ?>"></div>
</section>
<!-- Investment Plan section end -->
<?php echo $__env->make('frontend::home.include.__newsletter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend::pages.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ekobitt/public_html/app/Providers/../../resources/views/frontend/coinefy/pages/schema.blade.php ENDPATH**/ ?>