
<?php $__env->startSection('title'); ?>
<?php echo e(__('Landing Section Management')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <div class="page-title">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="title-content">
                        <h2 class="title"><?php echo e(__('Landing Section Management')); ?></h2>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-12">
        <div class="site-card">
            <div class="site-card-header">
                <h3 class="title"><?php echo e(__('Manage Section Order')); ?></h3>
            </div>
            <form action="<?php echo e(route('admin.page.section.management.update')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="site-card-body">
                    <div class="site-table table-responsive mb-0">
                        <table class="table mb-0">
                            <thead>
                            <tr>
                                <th scope="col"><?php echo e(__('Section')); ?></th>
                                <th scope="col"><?php echo e(__('Order')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong><?php echo e($section->name); ?></strong>
                                    </td>
                                    <td>
                                        <div class="site-input-groups">
                                            <input type="text" name="section_order[<?php echo e($section->code); ?>]" class="box-input"
                                            value="<?php echo e($section->short); ?>">
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="site-card-footer">
                    <button type="submit" class="site-btn-sm primary-btn"><?php echo e(__('Save Changes')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ekobitt/public_html/resources/views/backend/page/section/management.blade.php ENDPATH**/ ?>