@extends('frontend::pages.index')
@section('title')
{{ $data->title }}
@endsection
@section('meta_keywords')
{{ $data['meta_keywords'] }}
@endsection
@section('meta_description')
{{ $data['meta_description'] }}
@endsection
@section('page-content')

@php
$blogs = \App\Models\Blog::where('locale',app()->getLocale())->latest()->get();
@endphp

<!-- Blog area start -->
<section class="blog-area section-space-top position-relative">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-5 col-xl-6 col-lg-6">
                <div class="section-heading section-title-space text-center">
                    <span class="section-subtitle">{{ $data->title_big }}</span>
                    <h2 class="section-title">{{ $data['blog_title_big'] }}</h2>
                </div>
            </div>
        </div>
        <div class="row g-20">
            @foreach($blogs as $blog)
            <div class="col-xxl-3 col-xl-4 col-lg-4">
                <article class="blog-five-item-item">
                    <div class="blog-thumb">
                        <a href="{{ route('blog-details',$blog->id) }}"><img src="{{ asset($blog->cover) }}" alt="blog img not found"></a>
                    </div>
                    <div class="blog-content">
                        <h3 class="blog-title"><a href="{{ route('blog-details',$blog->id) }}"> {{ $blog->title }}</a></h3>
                        <p class="description"> {!! Str::limit($blog->details,100) !!}</p>
                        <div class="blog-date">
                            <span>{{ $blog->created_at }}</span>
                        </div>
                        <div class="blog-link">
                            <a class="shape-shifter-btn" href="{{ route('blog-details',$blog->id) }}">
                                <div class="btn-hover-slide">
                                    <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path opacity="0.4" d="M12.5 22C18.0228 22 22.5 17.5228 22.5 12C22.5 6.47715 18.0228 2 12.5 2C6.97715 2 2.5 6.47715 2.5 12C2.5 17.5228 6.97715 22 12.5 22Z" fill="white"></path>
                                        <path d="M17.248 7H12.418C12.008 7 11.668 7.34 11.668 7.75C11.668 8.16 12.008 8.5 12.418 8.5H15.438L7.71805 16.22C7.42805 16.51 7.42805 16.99 7.71805 17.28C7.86805 17.43 8.05805 17.5 8.24805 17.5C8.43805 17.5 8.62805 17.43 8.77805 17.28L16.498 9.56V12.58C16.498 12.99 16.838 13.33 17.248 13.33C17.658 13.33 17.998 12.99 17.998 12.58V7.75C17.998 7.34 17.658 7 17.248 7Z" fill="white"></path>
                                    </svg>
                                    <span>{{ __('Continue Reading') }}</span>
                                </div>
                            </a>
                        </div>
                    </div>
                </article>
            </div>
            @endforeach

        </div>
    </div>
</section>
<!-- Blog area end -->
@include('frontend::home.include.__newsletter')

@endsection