<!--[if lte IE 9]>
<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
<![endif]-->

<!-- Pre loader start -->
<div id="preloader">
    <div class="sk-three-bounce">
        <div class="sk-child sk-bounce1"></div>
        <div class="sk-child sk-bounce2"></div>
        <div class="sk-child sk-bounce3"></div>
    </div>
</div>
<!-- Pre loader end -->

@if(setting('back_to_top','permission'))
    <!-- Backtotop start -->
    <div class="back-to-top-wrap coinefy cursor-pointer">
        <svg class="backtotop-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>
    <!-- Backtotop end -->
@endif

<!-- Offcanvas area start -->
<div class="fix">
    <div class="offcanvas-area">
        <div class="offcanva-wrapper">
            <div class="offcanvas-content">
                <div class="offcanvas-top d-flex justify-content-between align-items-center">
                    <div class="offcanvas-logo">
                        <a href="{{ route('home') }}" src="{{ asset(setting('site_logo','global')) }}" alt="logo not found">
                        </a>
                    </div>
                    <div class="offcanvas-close">
                        <button class="offcanvas-close-icon animation--flip">
                               <span class="offcanvas-m-lines">
                                   <span class="offcanvas-m-line line--1"></span><span class="offcanvas-m-line line--2"></span><span class="offcanvas-m-line line--3"></span>
                               </span>
                        </button>
                    </div>
                </div>
                <div class="mobile-menu fix"></div>
                <div class="offcanvas-content">

                    <div class="offcanvas-btn mb-3">
                        @auth('web')
                            <a class="site-btn secondary-btn btn-xxs" href="{{ route('user.dashboard') }}">{{ __('Dashboard') }}</a>
                        @else
                            <div class="offcanvas-header-btn-wrap d-flex flex-wrap gap-2">
                                <a class="shape-shifter-btn" href="{{ route('login') }}">
                                    <div class="btn-hover-slide">
                                        <span>{{ __('Login') }}</span>
                                    </div>
                                </a>
                                <a class="shape-shifter-btn primary-btn" href="{{ route('register') }}">
                                    <div class="btn-hover-slide">
                                        <span>{{ __('Register') }}</span>
                                    </div>
                                </a>
                            </div>
                        @endauth
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="offcanvas-overlay"></div>
<div class="offcanvas-overlay-white"></div>
<!-- Offcanvas area end -->

<!-- Header area start -->
<header>
    <!-- Header section start -->
    <div class="header-area header-style-five" id="header-sticky">
        <div class="header-inner">
            <div class="header-logo">
                <a href="{{ route('home') }}"><img src="{{ asset(setting('site_logo','global')) }}" alt="Logo not found"></a>
            </div>
            <div class="header-menu d-none d-lg-inline-flex">
                <nav class="td-main-menu" id="mobile-menu">
                    <ul>
                        @foreach($navigations as $navigation)
                            @if($navigation->page->status|| $navigation->page_id == null)
                                <li class="@if(url($navigation->url) == Request::url() ) active @endif">
                                    <a href="{{ url($navigation->url) }}">{{ $navigation->tname }}</a>
                                </li>
                            @endif
                        @endforeach
                    </ul>
                </nav>
            </div>
            <div class="header-right">
                <div class="header-action">
                    <div class="header-lang-item header-lang">
                            <span class="header-lang-toggle" id="header-lang-toggle">
                                {{ \App\Models\Language::where('locale', app()->getLocale())->first()->name }}
                                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_283_30461)">
                                        <path d="M9 16.5C13.1421 16.5 16.5 13.1421 16.5 9C16.5 4.85786 13.1421 1.5 9 1.5C4.85786 1.5 1.5 4.85786 1.5 9C1.5 13.1421 4.85786 16.5 9 16.5Z" stroke="#B7BCD1" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M9 1.5C7.07418 3.52211 6 6.20755 6 9C6 11.7924 7.07418 14.4779 9 16.5C10.9258 14.4779 12 11.7924 12 9C12 6.20755 10.9258 3.52211 9 1.5Z" stroke="#B7BCD1" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M1.5 9H16.5" stroke="#B7BCD1" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_283_30461">
                                            <rect width="18" height="18" fill="white"/>
                                        </clipPath>
                                    </defs>
                                </svg>
                            </span>
                        <ul id="language-list" class="hidden">
                            @foreach(\App\Models\Language::where('status', true)->get() as $lang)
                                <li>
                                    <a href="{{ route('language-update', ['name' => $lang->locale]) }}"
                                       class="{{ app()->getLocale() == $lang->locale ? 'active' : '' }}"
                                       data-lang="{{ $lang->name }}">
                                        {{ $lang->name }}
                                        <span class="icon"><i class="fa-regular fa-check"></i></span>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    <div class="header-btn-wrap d-none d-md-inline-flex">
                        @auth('web')
                            <a class="shape-shifter-btn primary-btn" href="{{ route('user.dashboard') }}">
                                <div class="btn-hover-slide">
                                    {{ __('Dashboard') }}
                                </div>
                            </a>
                        @else
                            <a class="shape-shifter-btn" href="{{ route('login') }}">
                                <div class="btn-hover-slide">
                                    {{ __('Login') }}
                                </div>
                            </a>
                            <a class="shape-shifter-btn primary-btn" href="{{ route('register') }}">
                                <div class="btn-hover-slide">
                                    {{ __('Register') }}
                                </div>
                            </a>
                    </div>
                    @endauth
                    <div class="header-hamburger d-lg-none">
                        <a class="sidebar-toggle" href="javascript:void(0)">
                            <span class="menu-icon"><span></span></span>
                        </a>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- Header section end -->
</header>
@push('script')
    <script>
        // Color Switcher
        $(".color-switcher").on('click', function() {
            "use strict"
            $("body").toggleClass("dark-theme");
            var url = '{{ route("mode-theme") }}';
            $.get(url)
        });


        document.addEventListener('DOMContentLoaded', function () {
            const toggleButton = document.getElementById('header-lang-toggle');
            const languageList = document.getElementById('language-list');

            toggleButton.addEventListener('click', function () {
                languageList.classList.toggle('hidden');
            });

            // Close the dropdown if the user clicks outside of it
            document.addEventListener('click', function (event) {
                if (!toggleButton.contains(event.target) && !languageList.contains(event.target)) {
                    languageList.classList.add('hidden');
                }
            });
        });



    </script>
@endpush