@php
$landingContent =\App\Models\LandingContent::where('type','whychooseus')->where('locale',app()->getLocale())->get();
@endphp

<!-- why choose section start -->
<section class="why-choose-section section-space-bottom">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-6 col-xl-6 col-lg-6">
                <div class="section-heading text-center section-title-space">
                    <span class="section-subtitle">{{ $data['title_small'] }}</span>
                    <h2 class="section-title">{{ $data['title_big'] }}</h2>
                </div>
            </div>
        </div>
        <div class="row gy-30">
            @foreach($landingContent as $content)
            <div class="col-xxl-3 col-xl-3 col-lg-3 col-lg-6 col-md-6">
                <div class="why-choose-item">
                    <div class="icon">
                        <span>
                            @if(content_exists($content->icon))
                            <img src="{{ asset($content->icon) }}">
                            @else
                                <i class="{{ $content->icon }}"></i>
                            @endif
                        </span>
                    </div>
                    <div class="contents">
                        <h4 class="title">{{ $content->title }}</h4>
                        <p class="description">{{ $content->description }}</p>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
<!-- why choose section end -->