@php
$landingContent =\App\Models\LandingContent::where('type','faq')->where('locale',app()->getLocale())->get()->chunk(3);

@endphp

<div class="big-coin-wrapper o-x-clip p-relative z-index-11">
    <div class="big-coin-shapes">
        <img src="{{asset('frontend/theme_base/coinefy/images/shapes/big-crypto-coins.png')}}" alt="crypto-coins">
    </div>
    <section class="faq-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-5 col-xl-6 col-lg-6">
                    <div class="section-heading text-center section-title-space">
                        <span class="section-subtitle">{{ $data['title_small'] }}</span>
                        <h2 class="section-title">{{ $data['title_big'] }}</h2>
                    </div>
                </div>
            </div>
            <div class="row gy-30 justify-content-center">
                @foreach($landingContent as $key => $contents)
                <div class="col-xxl-6">
                    <div class="accordion-wrapper site-faq">
                        <div class="accordion" id="accordion{{$key}}">
                            @foreach($contents as $k => $cont)
                            <div class="accordion-item">
                                <h6 class="accordion-header" id="heading{{$key}}-{{$k}}">
                                    <button class="accordion-button {{ $k != 0 ? 'collapsed' : '' }}" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{$key}}-{{$k}}" aria-expanded="{{ $k == 0 ? 'true' : 'false' }}" aria-controls="collapse{{$key}}-{{$k}}">
                                        <span>
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path opacity="0.4" d="M16.19 2H7.81C4.17 2 2 4.17 2 7.81V16.18C2 19.83 4.17 22 7.81 22H16.18C19.82 22 21.99 19.83 21.99 16.19V7.81C22 4.17 19.83 2 16.19 2Z" fill="white" />
                                                <path d="M16 12.75H8C7.59 12.75 7.25 12.41 7.25 12C7.25 11.59 7.59 11.25 8 11.25H16C16.41 11.25 16.75 11.59 16.75 12C16.75 12.41 16.41 12.75 16 12.75Z" fill="white" />
                                            </svg>
                                        </span>{{ $cont->title }}
                                    </button>
                                </h6>
                                <div id="collapse{{$key}}-{{$k}}" class="accordion-collapse collapse {{ $k == 0 ? 'show' : '' }}" aria-labelledby="heading{{$key}}-{{$k}}" data-bs-parent="#accordion{{$key}}">
                                    <div class="accordion-body">
                                        <p>{!! nl2br(e($cont->description)) !!}</p>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>
</div>