@php
$schemas = \App\Models\Schema::where('status',1)->with('schedule')->get(['id','name','type','min_amount','max_amount','fixed_amount']);
@endphp

<!-- Plan Profit section start -->
<section class="plan-profit-section p-relative fix z-index-11 section-space-bottom">
    <div class="container">
        <div class="row gy-50 align-items-center">
            <div class="col-xxl-5 col-xl-5 col-lg-6">
                <div class="section-heading section-title-space">
                    <span class="section-subtitle">{{ $data['calculation_title_small'] }}</span>
                    <h2 class="section-title">{{ $data['calculation_title_big'] }}</h2>
                </div>
                <div class="plan-profit-contant-wrtapper">
                    <div class="plan-profit-form">
                        <form action="#">
                            <div class="single-input">
                                <select name="selectCalculationPlan" id="selectPlan">
                                    @foreach($schemas as $schema)
                                    <option value="{{ $schema->id }}">{{ $schema->name }}
                                        ({{ $schema->type == 'range' ? $currencySymbol . $schema->min_amount . '-' . $currencySymbol . $schema->max_amount : $currencySymbol . $schema->fixed_amount }})
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="single-input">
                                <div class="input-field">
                                    <input type="text" id="enter-amount" placeholder="{{ __('Enter Amount') }}">
                                    <div class="icon">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.4" d="M12 21.9004C17.5228 21.9004 22 17.4232 22 11.9004C22 6.37754 17.5228 1.90039 12 1.90039C6.47715 1.90039 2 6.37754 2 11.9004C2 17.4232 6.47715 21.9004 12 21.9004Z" fill="white" />
                                            <path d="M14.2563 12L12.7463 11.47V8.08H13.1062C13.9162 8.08 14.5763 8.79 14.5763 9.66C14.5763 10.07 14.9163 10.41 15.3263 10.41C15.7362 10.41 16.0763 10.07 16.0763 9.66C16.0763 7.96 14.7462 6.58 13.1062 6.58H12.7463V6C12.7463 5.59 12.4062 5.25 11.9963 5.25C11.5863 5.25 11.2463 5.59 11.2463 6V6.58H10.5963C9.11625 6.58 7.90625 7.83 7.90625 9.36C7.90625 11.15 8.94625 11.72 9.73625 12L11.2463 12.53V15.91H10.8863C10.0763 15.91 9.41625 15.2 9.41625 14.33C9.41625 13.92 9.07625 13.58 8.66625 13.58C8.25625 13.58 7.91625 13.92 7.91625 14.33C7.91625 16.03 9.24625 17.41 10.8863 17.41H11.2463V18C11.2463 18.41 11.5863 18.75 11.9963 18.75C12.4062 18.75 12.7463 18.41 12.7463 18V17.42H13.3962C14.8762 17.42 16.0863 16.17 16.0863 14.64C16.0763 12.84 15.0363 12.27 14.2563 12ZM10.2362 10.59C9.72625 10.41 9.41625 10.24 9.41625 9.37C9.41625 8.66 9.94625 8.09 10.6062 8.09H11.2563V10.95L10.2362 10.59ZM13.3962 15.92H12.7463V13.06L13.7563 13.41C14.2663 13.59 14.5763 13.76 14.5763 14.63C14.5763 15.34 14.0462 15.92 13.3962 15.92Z" fill="white" />
                                        </svg>
                                    </div>
                                </div>
                                <p class="input-description"></p>
                            </div>
                            <div class="single-input">
                                <div class="input-field">
                                    <input type="text" id="profit" placeholder="{{ __('Profit') }}" disabled>
                                    <div class="icon">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.4" d="M17 7.75C16.81 7.75 16.62 7.68 16.47 7.53C16.18 7.24 16.18 6.76 16.47 6.47L18.52 4.42C16.76 2.92 14.49 2 12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 9.51 21.08 7.24 19.58 5.48L17.53 7.53C17.38 7.68 17.19 7.75 17 7.75Z" fill="white" />
                                            <path d="M13.75 11.82L12.75 11.47V9.25H12.83C13.34 9.25 13.75 9.7 13.75 10.25C13.75 10.66 14.09 11 14.5 11C14.91 11 15.25 10.66 15.25 10.25C15.25 8.87 14.17 7.75 12.83 7.75H12.75V7.5C12.75 7.09 12.41 6.75 12 6.75C11.59 6.75 11.25 7.09 11.25 7.5V7.75H10.95C9.74001 7.75 8.75 8.77 8.75 10.03C8.75 11.49 9.6 11.96 10.25 12.19L11.25 12.54V14.76H11.17C10.66 14.76 10.25 14.31 10.25 13.76C10.25 13.35 9.91 13.01 9.5 13.01C9.09 13.01 8.75 13.35 8.75 13.76C8.75 15.14 9.83001 16.26 11.17 16.26H11.25V16.51C11.25 16.92 11.59 17.26 12 17.26C12.41 17.26 12.75 16.92 12.75 16.51V16.26H13.05C14.26 16.26 15.25 15.24 15.25 13.98C15.25 12.51 14.4 12.04 13.75 11.82ZM10.74 10.76C10.4 10.64 10.25 10.57 10.25 10.02C10.25 9.59 10.57 9.24 10.95 9.24H11.25V10.93L10.74 10.76ZM13.05 14.75H12.75V13.06L13.26 13.24C13.6 13.36 13.75 13.43 13.75 13.98C13.75 14.4 13.43 14.75 13.05 14.75Z" fill="white" />
                                            <path d="M22.6922 1.71024C22.6122 1.53024 22.4722 1.38024 22.2822 1.30024C22.1922 1.26024 22.0922 1.24023 21.9922 1.24023H17.9922C17.5822 1.24023 17.2422 1.58023 17.2422 1.99023C17.2422 2.40023 17.5822 2.74023 17.9922 2.74023H20.1822L18.5122 4.41024C18.8922 4.74024 19.2422 5.09024 19.5722 5.47024L21.2422 3.80024V6.00024C21.2422 6.41024 21.5822 6.75024 21.9922 6.75024C22.4022 6.75024 22.7422 6.41024 22.7422 6.00024V2.00024C22.7522 1.90024 22.7322 1.81024 22.6922 1.71024Z" fill="white" />
                                        </svg>
                                    </div>
                                </div>
                                <p class="input-description">{{ __('Profit:') }} <span id="profit-label"></span></p>
                            </div>
                            <div class="investment-gradient-btn">
                                <a class="shape-shifter-btn primary-btn" href="{{ route('register') }}">
                                    <div class="btn-hover-slide">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path opacity="0.4" d="M17 7.75C16.81 7.75 16.62 7.68 16.47 7.53C16.18 7.24 16.18 6.76 16.47 6.47L18.52 4.42C16.76 2.92 14.49 2 12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 9.51 21.08 7.24 19.58 5.48L17.53 7.53C17.38 7.68 17.19 7.75 17 7.75Z" fill="white" />
                                            <path d="M13.75 11.82L12.75 11.47V9.25H12.83C13.34 9.25 13.75 9.7 13.75 10.25C13.75 10.66 14.09 11 14.5 11C14.91 11 15.25 10.66 15.25 10.25C15.25 8.87 14.17 7.75 12.83 7.75H12.75V7.5C12.75 7.09 12.41 6.75 12 6.75C11.59 6.75 11.25 7.09 11.25 7.5V7.75H10.95C9.74001 7.75 8.75 8.77 8.75 10.03C8.75 11.49 9.6 11.96 10.25 12.19L11.25 12.54V14.76H11.17C10.66 14.76 10.25 14.31 10.25 13.76C10.25 13.35 9.91 13.01 9.5 13.01C9.09 13.01 8.75 13.35 8.75 13.76C8.75 15.14 9.83001 16.26 11.17 16.26H11.25V16.51C11.25 16.92 11.59 17.26 12 17.26C12.41 17.26 12.75 16.92 12.75 16.51V16.26H13.05C14.26 16.26 15.25 15.24 15.25 13.98C15.25 12.51 14.4 12.04 13.75 11.82ZM10.74 10.76C10.4 10.64 10.25 10.57 10.25 10.02C10.25 9.59 10.57 9.24 10.95 9.24H11.25V10.93L10.74 10.76ZM13.05 14.75H12.75V13.06L13.26 13.24C13.6 13.36 13.75 13.43 13.75 13.98C13.75 14.4 13.43 14.75 13.05 14.75Z" fill="white" />
                                            <path d="M22.6922 1.71024C22.6122 1.53024 22.4722 1.38024 22.2822 1.30024C22.1922 1.26024 22.0922 1.24023 21.9922 1.24023H17.9922C17.5822 1.24023 17.2422 1.58023 17.2422 1.99023C17.2422 2.40023 17.5822 2.74023 17.9922 2.74023H20.1822L18.5122 4.41024C18.8922 4.74024 19.2422 5.09024 19.5722 5.47024L21.2422 3.80024V6.00024C21.2422 6.41024 21.5822 6.75024 21.9922 6.75024C22.4022 6.75024 22.7422 6.41024 22.7422 6.00024V2.00024C22.7522 1.90024 22.7322 1.81024 22.6922 1.71024Z" fill="white" />
                                        </svg>
                                        {{ __('Let’s Start Earning') }}
                                    </div>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-xxl-7 col-xl-7 col-lg-6">
                <div class="plan-profit-eath">
                    <div class="circles_wrap include-bg" data-background="{{ asset('frontend/theme_base/coinefy/images/profit-plan/circle-pattern.png')}}">
                        <div class="circle circle0">
                            <div class="coin_wrap">
                                <div class="coin">
                                    <img src="{{ asset('frontend/theme_base/coinefy/images/profit-plan/06.png')}}" alt="image not found">
                                </div>
                                <div class="coin"></div>
                                <div class="coin"></div>
                                <div class="coin"></div>
                                <div class="coin"></div>
                                <div class="coin"></div>
                            </div>
                        </div>
                        <div class="circle circle1">
                            <div class="coin_wrap">
                                <div class="coin"></div>
                                <div class="coin"></div>
                                <div class="coin">
                                    <img src="{{ asset('frontend/theme_base/coinefy/images/profit-plan/05.png')}}" alt="image not found">
                                </div>
                                <div class="coin"></div>
                                <div class="coin"></div>
                                <div class="coin"></div>
                            </div>
                        </div>
                        <div class="circle circle2">
                            <div class="coin_wrap">
                                <div class="coin">
                                    <img src="{{ asset('frontend/theme_base/coinefy/images/profit-plan/04.png')}}" alt="image not found">
                                </div>
                                <div class="coin"></div>
                                <div class="dot"></div>
                                <div class="coin"></div>
                                <div class="coin"></div>
                                <div class="coin"></div>
                            </div>
                        </div>
                        <div class="circle circle3">
                            <div class="coin_wrap">
                                <div class="coin"></div>
                                <div class="coin"></div>
                                <div class="coin"></div>
                                <div class="dot"></div>
                                <div class="coin">
                                    <img src="{{ asset('frontend/theme_base/coinefy/images/profit-plan/03.png')}}" alt="image not found">
                                </div>
                                <div class="coin"></div>
                            </div>
                        </div>
                        <div class="circle circle4">
                            <div class="coin_wrap">
                                <div class="coin"></div>
                                <div class="coin">
                                    <img src="{{ asset('frontend/theme_base/coinefy/images/profit-plan/02.png')}}" alt="image not found">
                                </div>
                                <div class="coin"></div>
                                <div class="dot"></div>
                                <div class="coin"></div>
                                <div class="coin"></div>
                            </div>
                        </div>
                        <div class="circle circle5">
                            <div class="coin_wrap">
                                <div class="coin"></div>
                                <div class="coin">
                                    <img src="{{ asset('frontend/theme_base/coinefy/images/profit-plan/01.png')}}" alt="image not found">
                                </div>
                                <div class="coin"></div>
                                <div class="dot"></div>
                                <div class="coin"></div>
                                <div class="coin"></div>
                            </div>
                        </div>
                        <div class="circle_center">
                            <img src="{{ asset('frontend/theme_base/coinefy/images/profit-plan/0.png')}}" alt="image not found">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Plan Profit section end -->

@push('script')
<script>
    $('#selectPlan').on('change', function(e) {
        e.preventDefault();

        var id = $(this).val();

        if (id != 0) {
            var invest_amount = $("#enter-amount");
            invest_amount.val('');
            invest_amount.attr('readonly', false);

            var url = '{{ route("user.schema.select", ":id") }}';

            url = url.replace(':id', id);

            $.ajax({
                url: url,
                success: function(result) {
                    $('#amount-level').html('Capital Back: ' + result.capital_back);
                    $('#profit-label').html(result.return_interest + ' - ' + result.number_period);

                    if (result.invest_amount > 0) {
                        invest_amount.val(result.invest_amount);
                        invest_amount.attr('readonly', true);
                    }

                    calculateProfit(result);
                }
            });
        }
    });

    $('#enter-amount').on('keyup', function(e) {
        e.preventDefault();
        var id = $('#selectPlan').val();

        if (id != 0) {
            var url = '{{ route("user.schema.select", ":id") }}';
            url = url.replace(':id', id);

            $.ajax({
                url: url,
                success: function(result) {
                    calculateProfit(result);
                }
            });
        }
    });

    function calculateProfit(result) {
        console.log(result.roi_interest_type);
        var invest_amount = $("#enter-amount").val();

        if (result.number_period === 'Unlimited Times') {
            $('#profit').val('Unlimited');
        } else {
            if (result.interest_type === 'range') {
                if (result.roi_interest_type === 'percentage') {
                    $('#profit').val(result.min_roi + '%' + ' - ' + result.max_roi + '%');
                } else {
                    $('#profit').val('$' + result.min_roi + ' - $' + result.max_roi);
                }
            } else {
                $('#profit').val(calPercentage(invest_amount, result.interest) * result.period);
            }
        }
    }

    function calPercentage(amount, percentage) {
        return (amount * percentage) / 100;
    }
</script>
@endpush