@extends('frontend::layouts.auth')
@section('title')
{{ __('2FA Security') }}
@endsection
@section('content')
<div class="forgot-password-area">
    <div class="auth-inner">
        <div class="auth-wrapper">
            <div class="auth-from-inner">
                <div class="auth-from-top-content">
                    <div class="auth-logo">
                        <a href="{{ route('home')}}"><img src="{{ asset(setting('site_logo','global')) }}" alt="" /></a>
                    </div>
                    <h3 class="title">{{ __('2Step Verification') }}</h3>
                </div>
                @if ($errors->any())
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    @foreach($errors->all() as $error)
                    <strong>{{$error}}</strong>
                    @endforeach
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                @endif

                @if(session('status'))
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <strong>{{ session('status') }}</strong>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                @endif
                <div class="auth-from-box">
                    <form id="login-form" novalidate action="{{ route('user.setting.2fa.verify') }}" method="POST">
                        @csrf
                        <div class="coinefy-single-input has-right-icon mb-25">
                            <div class="input-field">
                                <span class="input-icon"><i class="icon-sms"></i>
                                    {{ __('Please enter the') }}
                                    <strong>{{ __('OTP') }}</strong> {{ __('generated on your Authenticator App.') }}
                                    <br> {{ __('Ensure you submit the current one because it refreshes every 30 seconds.') }}</span>
                                <input type="password" name="one_time_password" required>

                            </div>
                            <p class="feedback-invalid">This field is required</p>
                        </div>
                        <div class="auth-from-btn-wrap">
                            <button class="site-btn primary-btn w-100" type="submit">{{ __('Authenticate Now') }}</button>
                        </div>
                    </form>
                </div>
                <div class="auth-from-bottom-content">
                    <div class="auth-privacy-policy">
                        <p class="description">By clicking Sign in, you agree to our <a class="link" href="{{url('/terms-and-conditions')}}"> Terms & Condition</a> <span>and</span> <a class="link" href="{{url('/privacy-policy')}}"> Privacy Policy</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection