@extends('frontend::layouts.auth')
@section('title')
{{ __('Reset Password') }}
@endsection
@section('content')
<div class="forgot-password-area">
    <div class="auth-inner">
        <div class="auth-wrapper">
            <div class="auth-from-inner">
                <div class="auth-from-top-content">
                    <div class="auth-logo">
                        <a href="{{ route('home')}}"><img src="{{ asset(setting('site_logo','global')) }}" alt="" /></a>
                    </div>
                    <h3 class="title">{{ __('Reset Password') }}</h3>
                    <p class="description">{{ __('Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.') }}</p>
                </div>
                @if ($errors->any())
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    @foreach($errors->all() as $error)
                    <strong>{{$error}}</strong>
                    @endforeach
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                @endif

                @if(session('status'))
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <strong>{{ session('status') }}</strong>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                @endif
                <div class="auth-from-box">
                    <form id="login-form" novalidate action="{{ route('password.update') }}" method="POST">
                        @csrf
                        <input type="hidden" name="token" value="{{ $request->route('token') }}">
                        <div class="coinefy-single-input has-right-icon mb-25">
                            <div class="input-field">
                                <input type="email" name="email" class="box-input" placeholder="{{ __('Email Address') }}" required value="{{ old('email',$request->email) }}">
                                <span class="input-icon"><i class="fa-regular fa-user"></i></span>
                            </div>
                            <p class="feedback-invalid">This field is required</p>
                        </div>
                        <div class="coinefy-single-input has-right-icon mb-25">
                            <div class="input-field">
                                <input type="password" name="password" class="box-input password-input" placeholder="{{ __('New Password') }}" required>
                                <span class="input-icon eyeicon"><i class="fa-sharp fa-light fa-eye-slash"></i></span>
                            </div>
                            <p class="feedback-invalid">This field is required</p>
                        </div>
                        <div class="coinefy-single-input has-right-icon mb-25">
                            <div class="input-field">
                                <input type="password" name="password_confirmation" class="box-input password-input" placeholder="{{ __('Confirm Password') }}" required>
                                <span class="input-icon eyeicon"><i class="fa-sharp fa-light fa-eye-slash"></i></span>
                            </div>
                            <p class="feedback-invalid">This field is required</p>
                        </div>
                        <div class="auth-from-btn-wrap">
                            <button class="site-btn primary-btn w-100" type="submit">{{ __('Reset Password') }}</button>
                        </div>
                    </form>
                </div>
                <div class="auth-from-bottom-content">
                    <div class="auth-privacy-policy">
                        <p class="description">By clicking Sign in, you agree to our <a class="link" href="{{url('/terms-and-conditions')}}"> Terms & Condition</a> <span>and</span> <a class="link" href="{{url('/privacy-policy')}}"> Privacy Policy</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        $('.eyeicon').on('click', function() {
            let passwordInput = $(this).siblings('.password-input');
            let icon = $(this).find('i');

            if (passwordInput.attr('type') === 'password') {
                passwordInput.attr('type', 'text');
                icon.removeClass('fa-eye-slash').addClass('fa-eye');
            } else {
                passwordInput.attr('type', 'password');
                icon.removeClass('fa-eye').addClass('fa-eye-slash');
            }
        });
    });
</script>