@extends('frontend::layouts.auth')

@section('title')
    {{ __('Register') }}
@endsection
@section('content')

    <!-- Sign up area start -->
    <div class="sign-up-area">
        <div class="auth-inner">
            <div class="auth-wrapper sing-up">
                <div class="auth-from-inner">
                    <div class="auth-from-top-content">
                        <div class="auth-logo">
                            <a href="{{ route('home') }}">
                                <img src="{{ asset(setting('site_logo', 'global')) }}" alt="logo">
                            </a>
                        </div>
                        <h3 class="title">{{ $data['title'] }}</h3>
                        <p class="description">{{ $data['bottom_text'] }}</p>
                    </div>
                    <div class="auth-from-box">
                        @if ($errors->any())
                            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                @foreach ($errors->all() as $error)
                                    <strong>{{ $error }}</strong>
                                @endforeach
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <form action="{{ route('register') }}" id="signUpForm" method="POST">
                            @csrf
                            <div class="row g-24">
                                <div class="col-xxl-6 col-xl-6 col-lg-6">
                                    <div class="coinefy-single-input has-right-icon">
                                        <div class="input-field">
                                            <input type="text" name="first_name" class="box-input"
                                                placeholder="{{ __('First Name') }}" required
                                                value="{{ old('first_name') }}">
                                            <span class="input-icon"><i class="fa-regular fa-user"></i></span>
                                        </div>
                                        <p class="feedback-invalid">This field is required</p>
                                    </div>
                                </div>
                                <div class="col-xxl-6 col-xl-6 col-lg-6">
                                    <div class="coinefy-single-input has-right-icon">
                                        <div class="input-field">
                                            <input type="text" name="last_name" class="box-input"
                                                placeholder="{{ __('Last Name') }}" required
                                                value="{{ old('last_name') }}">
                                            <span class="input-icon"><i class="fa-regular fa-user"></i></span>
                                        </div>
                                        <p class="feedback-invalid">This field is required</p>
                                    </div>
                                </div>
                                <div class="col-xxl-6 col-xl-6 col-lg-6">
                                    <div class="coinefy-single-input has-right-icon">
                                        <div class="input-field">
                                            <input type="email" name="email" class="box-input"
                                                placeholder="{{ __('Email Address') }}" required
                                                value="{{ old('email') }}">
                                            <span class="input-icon"><i class="fa-light fa-envelope-open"></i></span>
                                        </div>
                                        <p class="feedback-invalid">This field is required</p>
                                    </div>
                                </div>
                                @if (getPageSetting('username_show'))
                                    <div class="col-xxl-6 col-xl-6 col-lg-6">
                                        <div class="coinefy-single-input has-right-icon">
                                            <div class="input-field">
                                                <input type="text" name="username" class="box-input"
                                                    placeholder="{{ __('Username') }}" required
                                                    value="{{ old('username') }}">
                                                <span class="input-icon"><i class="fa-regular fa-user"></i></span>
                                            </div>
                                            <p class="feedback-invalid">This field is required</p>
                                        </div>
                                    </div>
                                @endif
                                @if (getPageSetting('country_show'))
                                    <div class="col-xxl-6 col-xl-6 col-lg-6">
                                        <div class="coinefy-single-input">
                                            <div class="coinefy-input-filter">
                                                <select name="country" id="countrySelect">
                                                    @foreach (getCountries() as $country)
                                                        <option @if ($location->country_code == $country['code']) selected @endif
                                                            value="{{ $country['name'] . ':' . $country['dial_code'] }}">
                                                            {{ $country['name'] }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                @if (getPageSetting('phone_show'))
                                    <div class="col-xxl-6 col-xl-6 col-lg-6">
                                        <div class="coinefy-single-input">
                                            <div class="input-field input-group">
                                                <span class="input-group-text"
                                                    id="dial-code">{{ getLocation()->dial_code }}</span>
                                                <input type="text" name="phone" placeholder="{{ __('Phone Number') }}"
                                                    value="{{ old('phone') }}">
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                @if (getPageSetting('referral_code_show'))
                                    <div class="col-xxl-6 col-xl-6 col-lg-6">
                                        <div class="coinefy-single-input has-right-icon">
                                            <div class="input-field">
                                                <input type="text" name="invite" class="box-input"
                                                    placeholder="{{ __('Referral Code') }}"
                                                    value="{{ request('invite') ?? old('invite') }}">
                                                <span class="input-icon"><i class="fa-regular fa-users"></i></span>
                                            </div>

                                        </div>
                                    </div>
                                @endif
                                @if (getPageSetting('register_custom_fields'))
                                    @php
                                        $customFields = json_decode(getPageSetting('register_custom_fields'), true);
                                    @endphp
                                    @foreach ($customFields as $key => $field)
                                        <div class="col-xxl-6 col-xl-6 col-lg-6">
                                            <div class="coinefy-single-input">
                                                <label class="box-label" for="">{{ $field['name'] }} @if ($field['validation'] == 'required')
                                                        <span class="text-danger">*</span>
                                                    @endif
                                                </label>
                                                @if ($field['type'] == 'textarea')
                                                    <div class="input-field">
                                                        <textarea name="custom_fields_data[{{ $field['name'] }}]" class="form-control" rows="3"
                                                            @if ($field['validation'] == 'required') required @endif></textarea>
                                                    </div>
                                                @elseif(in_array($field['type'], ['file', 'camera']))
                                                <div class="rock-upload-input">
                                                    <div class="upload-custom-file without-image">
                                                        <input type="file" id="{{ $key }}"
                                                            name="custom_fields_data[{{ $field['name'] }}]"
                                                            accept=".gif, .jpg, .png"
                                                            onchange="showCloseButton(event)"
                                                            @if ($field['type'] == 'camera') capture="user" @endif />
                                                        <label for="{{ $key }}">
                                                            <span class="upload-icon">
                                                                <svg width="48" height="48"
                                                                    viewBox="0 0 48 48" fill="none"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <g filter="url(#filter0_i_2427_12057)">
                                                                        <path
                                                                            d="M14 18L34 18C38.4183 18 42 21.5817 42 26V34C42 38.4183 38.4183 42 34 42H14C9.58172 42 6 38.4183 6 34L6 26C6 21.5817 9.58172 18 14 18Z"
                                                                            fill="url(#paint0_linear_2427_12057)" />
                                                                    </g>
                                                                    <path
                                                                        d="M14 18.5L34 18.5C38.1421 18.5 41.5 21.8579 41.5 26V34C41.5 38.1421 38.1421 41.5 34 41.5H14C9.85787 41.5 6.5 38.1421 6.5 34L6.5 26C6.5 21.8579 9.85786 18.5 14 18.5Z"
                                                                        stroke="white" stroke-opacity="0.08" />
                                                                    <g filter="url(#filter1_i_2427_12057)">
                                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                                            d="M16.9393 13.0607C16.3536 12.4749 16.3536 11.5251 16.9393 10.9393L22.9393 4.93934C23.5251 4.35355 24.4749 4.35355 25.0607 4.93934L31.0607 10.9393C31.6464 11.5251 31.6464 12.4749 31.0607 13.0607C30.4749 13.6464 29.5251 13.6464 28.9393 13.0607C27.6701 11.7915 25.5 12.6904 25.5 14.4853L25.5 30C25.5 30.8284 24.8284 31.5 24 31.5C23.1716 31.5 22.5 30.8284 22.5 30L22.5 14.4853C22.5 12.6904 20.3299 11.7915 19.0607 13.0607C18.4749 13.6464 17.5251 13.6464 16.9393 13.0607Z"
                                                                            fill="url(#paint1_linear_2427_12057)" />
                                                                    </g>
                                                                    <path
                                                                        d="M17.2929 12.7071C16.9024 12.3166 16.9024 11.6834 17.2929 11.2929L23.2929 5.29289C23.6834 4.90237 24.3166 4.90237 24.7071 5.29289L30.7071 11.2929C31.0976 11.6834 31.0976 12.3166 30.7071 12.7071C30.3166 13.0976 29.6834 13.0976 29.2929 12.7071C27.7087 11.1229 25 12.2449 25 14.4853L25 30C25 30.5523 24.5523 31 24 31C23.4477 31 23 30.5523 23 30L23 14.4853C23 12.2449 20.2913 11.1229 18.7071 12.7071C18.3166 13.0976 17.6834 13.0976 17.2929 12.7071Z"
                                                                        stroke="white" stroke-opacity="0.08" />
                                                                    <defs>
                                                                        <filter id="filter0_i_2427_12057" x="2" y="18"
                                                                            width="40" height="28"
                                                                            filterUnits="userSpaceOnUse"
                                                                            color-interpolation-filters="sRGB">
                                                                            <feFlood flood-opacity="0"
                                                                                result="BackgroundImageFix" />
                                                                            <feBlend mode="normal" in="SourceGraphic"
                                                                                in2="BackgroundImageFix"
                                                                                result="shape" />
                                                                            <feColorMatrix in="SourceAlpha"
                                                                                type="matrix"
                                                                                values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                                                result="hardAlpha" />
                                                                            <feOffset dx="-4" dy="4" />
                                                                            <feGaussianBlur stdDeviation="5" />
                                                                            <feComposite in2="hardAlpha"
                                                                                operator="arithmetic" k2="-1"
                                                                                k3="1" />
                                                                            <feColorMatrix type="matrix"
                                                                                values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0" />
                                                                            <feBlend mode="normal" in2="shape"
                                                                                result="effect1_innerShadow_2427_12057" />
                                                                        </filter>
                                                                        <filter id="filter1_i_2427_12057" x="12.5"
                                                                            y="4.5" width="19" height="31"
                                                                            filterUnits="userSpaceOnUse"
                                                                            color-interpolation-filters="sRGB">
                                                                            <feFlood flood-opacity="0"
                                                                                result="BackgroundImageFix" />
                                                                            <feBlend mode="normal" in="SourceGraphic"
                                                                                in2="BackgroundImageFix"
                                                                                result="shape" />
                                                                            <feColorMatrix in="SourceAlpha"
                                                                                type="matrix"
                                                                                values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                                                result="hardAlpha" />
                                                                            <feOffset dx="-4" dy="4" />
                                                                            <feGaussianBlur stdDeviation="5" />
                                                                            <feComposite in2="hardAlpha"
                                                                                operator="arithmetic" k2="-1"
                                                                                k3="1" />
                                                                            <feColorMatrix type="matrix"
                                                                                values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0" />
                                                                            <feBlend mode="normal" in2="shape"
                                                                                result="effect1_innerShadow_2427_12057" />
                                                                        </filter>
                                                                        <linearGradient id="paint0_linear_2427_12057"
                                                                            x1="6" y1="18"
                                                                            x2="28.1538" y2="51.2308"
                                                                            gradientUnits="userSpaceOnUse">
                                                                            <stop stop-color="#FDD819" />
                                                                            <stop offset="1"
                                                                                stop-color="#F81717" />
                                                                        </linearGradient>
                                                                        <linearGradient id="paint1_linear_2427_12057"
                                                                            x1="16.5" y1="31.5"
                                                                            x2="39.4245" y2="18.7641"
                                                                            gradientUnits="userSpaceOnUse">
                                                                            <stop stop-color="#FDD819" />
                                                                            <stop offset="1"
                                                                                stop-color="#F81717" />
                                                                        </linearGradient>
                                                                    </defs>
                                                                </svg>
                                                            </span>
                                                            <span>{{ __('Select') }} {{ $field['name'] }}</span>
                                                        </label>
                                                    </div>
                                                </div>
                                                @else
                                                    <div class="input-field">
                                                        <input type="text"
                                                            name="custom_fields_data[{{ $field['name'] }}]"
                                                            class="box-input"
                                                            @if ($field['validation'] == 'required') required @endif>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                                <div class="col-xxl-6 col-xl-6 col-lg-6">
                                    <div class="coinefy-single-input has-right-icon">
                                        <div class="input-field">
                                            <input type="password" name="password" class="box-input password-input"
                                                id="new-password" placeholder="{{ __('Password') }}" required>
                                            <span class="input-icon eyeicon"><i
                                                    class="fa-sharp fa-light fa-eye-slash"></i></span>
                                        </div>
                                        <p class="feedback-invalid">This field is required</p>
                                    </div>
                                </div>
                                <div class="col-xxl-6 col-xl-6 col-lg-6">
                                    <div class="coinefy-single-input has-right-icon">
                                        <div class="input-field">
                                            <input type="password" name="password_confirmation"
                                                class="box-input password-input" id="confirm-password"
                                                placeholder="{{ __('Confirm Password') }}" required>
                                            <span class="input-icon eyeicon"><i
                                                    class="fa-sharp fa-light fa-eye-slash"></i></span>
                                        </div>
                                        <p class="feedback-invalid">This field is required</p>
                                        <!-- <p class="input-description">Must be at least eight character (1 uppercase, 1 lowercase letter, 1 number and 1 special character)</p> -->
                                    </div>
                                </div>
                                @if ($googleReCaptcha)
                                    <div class="g-recaptcha" id="feedback-recaptcha"
                                        data-sitekey="{{ json_decode($googleReCaptcha->data, true)['google_recaptcha_key'] }}">
                                    </div>
                                @endif
                                <div class="col-xxl-12">
                                    <div class="animate-custom">
                                        <input class="inp-cbx" name="i_agree" id="auth_remind" value="yes"
                                            type="checkbox" style="display: none;">
                                        <label class="cbx" for="auth_remind">
                                            <span>
                                                <svg width="12px" height="9px" viewbox="0 0 12 9">
                                                    <polyline points="1 5 4 8 11 1"></polyline>
                                                </svg>
                                            </span>
                                            <span>{{ __('I agree with') }} <a class="link"
                                                    href="{{ url('/privacy-policy') }}"> Privacy Policy </a> and <a
                                                    href="{{ url('/terms-and-conditions') }}">
                                                    {{ __('Terms & Condition') }} </a></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-xxl-12">
                                    <div class="auth-from-btn-wrap mt-5">
                                        <button class="site-btn primary-btn w-100" type="submit"
                                            form="signUpForm">{{ __('Create Account') }}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="auth-from-bottom-content">
                        <div class="auth-account">
                            <p class="description">{{ __('Already have an account?') }} <a class="link"
                                    href="{{ route('login') }}"> {{ __('Login') }}</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Sign up area end -->

@endsection
@section('script')
    @if ($googleReCaptcha)
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    @endif
    <script>
        $('#countrySelect').on('change', function(e) {
            "use strict";
            e.preventDefault();
            var country = $(this).val();
            $('#dial-code').html(country.split(":")[1])
        })
    </script>


    <script>
        $(document).ready(function() {
            $('.eyeicon').on('click', function() {
                let passwordInput = $(this).siblings('.password-input');
                let icon = $(this).find('i');

                if (passwordInput.attr('type') === 'password') {
                    passwordInput.attr('type', 'text');
                    icon.removeClass('fa-eye-slash').addClass('fa-eye');
                } else {
                    passwordInput.attr('type', 'password');
                    icon.removeClass('fa-eye').addClass('fa-eye-slash');
                }
            });
        });
    </script>
@endsection
