<!-- JS here -->
<script src="{{ asset('frontend/theme_base/coin_orbit/js/jquery-3.7.1.min.js') }}"></script>
<script src="{{ asset('frontend/theme_base/coin_orbit/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('frontend/theme_base/coin_orbit/js/cookie.js') }}"></script>
<script src="{{ asset('frontend/theme_base/coin_orbit/js/magnific-popup.min.js') }}"></script>
<script src="{{ asset('frontend/theme_base/coin_orbit/js/odometer.min.js') }}"></script>
<script src="{{ asset('frontend/theme_base/coin_orbit/js/jquery.appear.min.js') }}"></script>
<script src="{{ asset('frontend/theme_base/coin_orbit/js/select2.js') }}"></script>
<script src="{{ asset('frontend/theme_base/coin_orbit/js/swiper.min.js') }}"></script>

<!-- Gsap script -->
<script src="{{ asset('frontend/theme_base/coin_orbit/js/gsap/gsap.min.js') }}"></script>
<script src="{{ asset('frontend/theme_base/coin_orbit/js/gsap/ScrollSmoother.min.js') }}"></script>
<script src="{{ asset('frontend/theme_base/coin_orbit/js/gsap/ScrollToPlugin.min.js') }}"></script>
<script src="{{ asset('frontend/theme_base/coin_orbit/js/gsap/ScrollTrigger.min.js') }}"></script>
<script src="{{ asset('frontend/theme_base/coin_orbit/js/gsap/SplitText.min.js') }}"></script>

<script src="{{ asset('frontend/theme_base/coin_orbit/js/main.js') }}"></script>
<script src="{{ asset('frontend/theme_base/coin_orbit/js/error-handling.js') }}"></script>
<script>
    // accordion-item active
    $(document).on('click', '.accordion-item', function () {
        $('.accordion-item').removeClass('accordion-active'); // Remove active class from all
        $(this).addClass('accordion-active'); // Add active class to the clicked item
    });
</script>
<script>
    function reviewSliderActive($scope, $) {
        $scope.find('.payment_gateways_active .swiper-container').each(function () {
            let SwiperBottom = new Swiper(this, {
                spaceBetween: $(this).data('space-between'),
                centeredSlides: true,
                slidesPerView: $(this).data('slides'),
                speed: 6000,
                autoplay: {
                    delay: 1,
                },
                loop: true,
                allowTouchMove: false,
                disableOnInteraction: true,
                breakpoints: {
                    0: {
                        slidesPerView: 2,
                    },
                    480: {
                        slidesPerView: 3,
                    },
                    575: {
                        slidesPerView: 3,
                    },
                    787: {
                        slidesPerView: 3,
                    },
                    991: {
                        slidesPerView: 4,
                    },
                    1200: {
                        slidesPerView: 4,
                    },
                    1400: {
                        slidesPerView: 5,
                    },
                    1921: {
                        slidesPerView: 7,
                    }
                }
            });
        });
    }
    $(document).ready(function () {
        reviewSliderActive($(document), jQuery);
    });
</script>



<script>
    (function($) {
        'use strict';
        // MagnificPopup image
        $(".popup-image").magnificPopup({
            type: "image",
            gallery: {
                enabled: true,
            },
        });

        // MagnificPopup video
        $(".popup-video").magnificPopup({
            type: "iframe",
        });
    })(jQuery);
</script>

@include('global.__t_notify')
@if(auth()->check())
    <script src="{{ asset('global/js/pusher.min.js') }}"></script>
    @include('global.__notification_script',['for'=>'user','userId' => auth()->user()->id])
@endif

@notifyJs

@yield('script')
@stack('script')

@php
    $googleAnalytics = plugin_active('Google Analytics');
    $tawkChat = plugin_active('Tawk Chat');
    $fb = plugin_active('Facebook Messenger');
@endphp

@if($googleAnalytics)
    @include('frontend::plugin.google_analytics',['GoogleAnalyticsId' => json_decode($googleAnalytics?->data,true)['app_id']])
@endif
@if($tawkChat)
    @include('frontend::plugin.tawk',['data' => json_decode($tawkChat->data, true)])
@endif
@if($fb)
    @include('frontend::plugin.fb',['data' => json_decode($fb->data, true)])
@endif