@php
$investors = \App\Models\Invest::with('schema','user')->latest()->take(6)->get();
$withdraws = \App\Models\Transaction::where('type',\App\Enums\TxnType::Withdraw)->take(6)->latest()->get();
@endphp

<!-- Investors section start -->
<section class="td-investors-section section_space-bottom p-relative o-x-clip">
    <div class="container">
        <div class="row gy-30">
            <div class="col-xxl-6 col-xl-6 col-lg-6">
                <div class="section-title-wrapper section_title_space">
                    <span class="section-subtitle">{{ $data['title_small'] }}</span>
                    <h2 class="section-title has_fade_anim">{{ $data['title_big'] }}</h2>
                </div>
                <div class="table-container table-responsive has_fade_anim" data-fade-from="left">
                    <div class="table-heading">
                        <h4 class="title">{{ __('Recent Withdraws') }}</h4>
                    </div>
                    <table class="td-table">
                        <tbody>
                        @foreach($withdraws as $withdraw)
                        <tr>
                            <td>
                                <div class="description">
                                    <div class="icon">
                                          <span>
                                             <img src="{{ asset('frontend/theme_base/coin_orbit/images/investors/icons/withdraw.png') }}" alt="Withdraw Icons">
                                          </span>
                                    </div>
                                    <div class="contents">
                                        <h6 class="subject-title">{{ $withdraw->description }}</h6>
                                        <div class="d-flex align-items-center gap-2">
                                            <span class="date">{{ $withdraw->created_at }}</span>
                                            <span class="td-badge badge-warning">
                                                {{ ucfirst($withdraw->status->value) }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="warning-text fs-12 fw-5">
                                    @if($withdraw->status == \App\Enums\TxnStatus::Success)
                                        -{{ $withdraw->final_amount }} {{ $currency }}
                                    @elseif($withdraw->status == \App\Enums\TxnStatus::Failed)
                                        +{{ $withdraw->final_amount }} {{ $currency }}
                                    @elseif($withdraw->status == \App\Enums\TxnStatus::Pending)
                                        {{ $withdraw->final_amount }} {{ $currency }}
                                    @endif
                                </span>
                                <p style="color: #b7d3ff;" class="fs-14 fw-6">{{ __('Total') }}: {{ $withdraw->final_amount }} {{ $currency }}</p>
                            </td>
                        </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-xxl-6 col-xl-6 col-lg-6">
                <div class="table-container table-responsive has_fade_anim" data-fade-from="right">
                    <div class="table-heading">
                        <h4 class="title">Recent Investors</h4>
                    </div>
                    <table class="td-table">
                        <tbody>
                        @foreach($investors as $investor)
                            @php
                                $calculateInterest = ($investor->interest * $investor->invest_amount) / 100;
                                $interest = $investor->interest_type != 'percentage' ? $investor->interest : $calculateInterest;
                            @endphp
                        <tr>
                            <td>
                                <div class="description">
                                    <div class="icon">
                                          <span>
                                             <img src="{{ asset('frontend/theme_base/coin_orbit/images/investors/icons/user.png') }}" alt="User Icons">
                                          </span>
                                    </div>
                                    <div class="contents">
                                        <h6 class="subject-title">{{ $investor->user->full_name }}</h6>
                                        <div class="d-flex align-items-center gap-2">
                                            <span class="date">{{ $investor->created_at }}</span>
                                            <span class="td-badge badge-success">{{ $investor->user->status ? __('Active') : __('DeActive') }}</span>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="success-text fs-12 fw-5">+{{ $investor->already_return_profit * $interest }} {{ $currency }}</span>
                                <p style="color: #b7d3ff;" class="fs-14 fw-6">{{ $investor->invest_amount }} {{ $currency }}</p>
                            </td>
                        </tr>
                        @endforeach
                        <!-- Add more rows as necessary -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="investors-shapes">
        <div class="glow">
            <img src="{{ asset('frontend/theme_base/coin_orbit/images/investors/glow.png') }}" alt="Investors Glow">
        </div>
        <div class="line">
            <img src="{{ asset('frontend/theme_base/coin_orbit/images/investors/line.png') }}" alt="Investors Line">
        </div>
    </div>
</section>
<!-- Investors section end -->