<!-- Blog area start -->
<div class="td-blog-area position-relative z-index-11 section_space fix">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-5 col-xl-6 col-lg-8">
                <div class="section-title-wrapper text-center section_title_space">
                    <span class="section-subtitle">{{ $data['blog_title_small'] }}</span>
                    <h2 class="section-title has_fade_anim mb-15">{{ $data['blog_title_big'] }}</h2>
                </div>
            </div>
        </div>
        <div class="row gy-20">
            @foreach(\App\Models\Blog::where('locale',app()->getLocale())->latest()->get() as $blog)
            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6">
                <div class="has_fade_anim" data-fade-from="bottom" data-delay="0.30">
                    <article class="single-blog-item">
                        <div class="blog-thumb-box">
                            <div class="blog-thumb">
                                <a href="{{ route('blog-details',$blog->id) }}">
                                    <img src="{{ asset($blog->cover) }}" alt="blog img not found">
                                </a>
                            </div>
                            <div class="blog-date">
                                <span>{{ $blog->created_at }}</span>
                            </div>
                        </div>
                        <div class="blog-contents">
                            <h5 class="title">
                                <a href="{{ route('blog-details',$blog->id) }}">{{ $blog->title }}</a>
                            </h5>
                            <p class="description">{!! Str::limit($blog->details,100) !!}</p>
                            <div class="blog-link">
                                <a class="btn-text" href="{{ route('blog-details',$blog->id) }}">{{ __('Continue Reading') }}</a>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    <div class="blog-shapes d-none d-sm-block">
        <span class="shape-one"></span>
        <span class="shape-two"></span>
    </div>
</div>
<!-- Blog area end -->