@extends('backend.layouts.app')
@section('title')
    {{ __('Transactions') }}
@endsection
@section('content')
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <h2 class="title">{{$title}}</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-table table-responsive">
                        <form action="{{ request()->url() }}" method="get">
                            <div class="table-filter d-flex justify-content-between">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <input type="text" id="search" name="query" value="{{ request('query') }}" placeholder="Search" />
                                    </div>
                                    <button type="submit" class="apply-btn ms-2"><i data-lucide="search"></i>{{ __('Search') }}</button>
                                </div>
                                <div class="filter d-flex">
                                    <select class="form-select form-select-sm me-2" name="filter_by_transaction_type">
                                        <option value="" selected>{{ __('Filter By Transaction Type') }}</option>
                                        <option value="investment" {{ request('filter_by_transaction_type') == 'investment' ? 'selected' : '' }}>{{ __('Investment') }}</option>
                                        <option value="referral" {{ request('filter_by_transaction_type') == 'referral' ? 'selected' : '' }}>{{ __('Referral') }}</option>
                                        <option value="interest" {{ request('filter_by_transaction_type') == 'interest' ? 'selected' : '' }}>{{ __('Interest') }}</option>
                                        <option value="bonus" {{ request('filter_by_transaction_type') == 'bonus' ? 'selected' : '' }}>{{ __('Bonus') }}</option>
                                        <option value="signup_bonus" {{ request('filter_by_transaction_type') == 'signup_bonus' ? 'selected' : '' }}>{{ __('Signup Bonus') }}</option>
                                    </select>

                                </div>
                            </div>
                        </form>
                        <table class="table">
                            <thead>
                            <tr>
                                <th scope="col">{{ __('Date') }}</th>
                                <th scope="col">{{__('User')}}</th>
                                <th scope="col">{{__('Amount') }}</th>
                                <th scope="col">{{__('Type') }}</th>
                                <th scope="col">{{__('Profit From') }}</th>
                                <th scope="col">{{__('Description') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($data as $item)
                                <tr>
                                    <td>{{ $item->created_at }}</td>
                                    <td>@include('backend.transaction.include.__user', ['item' => $item])</td>
                                    <td>@include('backend.transaction.include.__txn_amount', ['item' => $item])</td>
                                    <td>@include('backend.transaction.include.__txn_type', ['item' => $item])</td>
                                    <td>{{ $item->from_user_id != null ? \App\Models\User::find($item->from_user_id)?->username : 'System' }}</td>
                                    <td>{{ $item->description }}</td>
                                </tr>
                            @empty
                                <td colspan="8" class="text-center">{{ __('No Data Found!') }}</td>
                            @endforelse
                            </tbody>
                        </table>
                        {{ $data->links('backend.include.__pagination') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection