@extends('backend.layouts.app')
@section('title')
    {{ __('Pending KYC') }}
@endsection
@section('content')
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <h2 class="title">{{$title}}</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-table table-responsive">
                        <form action="{{ request()->url() }}" method="get">
                            <div class="table-filter d-flex justify-content-between">
                                <div class="filter d-flex">
                                    <div class="search">
                                        <input type="text" id="search" name="query" value="{{ request('query') }}" placeholder="Search" />
                                    </div>
                                    <button type="submit" class="apply-btn ms-2"><i data-lucide="search"></i>{{ __('Search') }}</button>
                                </div>
                            </div>
                        </form>
                        <table class="table">
                            <thead>
                            <tr>
                                <th>{{ __('Date') }}</th>
                                <th>{{ __('User') }}</th>
                                <th>{{ __('Type') }}</th>
                                <th>{{ __('Status') }}</th>
                                <th>{{ __('Action') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse ($kycs as $kyc)
                                <tr>
                                    <td>@include('backend.kyc.include.__time', ['kyc' => $kyc])</td>
                                    <td>@include('backend.kyc.include.__user', ['kyc' => $kyc])</td>
                                    <td>@include('backend.kyc.include.__type', ['kyc' => $kyc])</td>
                                    <td>@include('backend.kyc.include.__status', ['kyc' => $kyc])</td>
                                    <td>@include('backend.kyc.include.__action', ['kyc' => $kyc])</td>
                                </tr>
                            @empty
                                <td colspan="8" class="text-center">{{ __('No Data Found!') }}</td>
                            @endforelse
                            </tbody>
                        </table>
                        {{ $kycs->links('backend.include.__pagination') }}
                    </div>
                </div>
            </div>
            <!-- Modal for Pending KYC Details -->
            @can('kyc-action')
                <div class="modal fade" id="kyc-action-modal" tabindex="-1" aria-labelledby="editPendingDepositModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-md modal-dialog-centered">
                        <div class="modal-content site-table-modal">
                            <div class="modal-body popup-body">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                <div class="popup-body-text" id="kyc-action-data">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        @endcan
        <!-- Modal for Pending KYC Details -->
        </div>
    </div>
@endsection
@section('script')
    <script>
        $('body').on('click', '#action-kyc', function(e) {
            "use strict";
            e.preventDefault()
            $('#kyc-action-data').empty();

            var id = $(this).data('id');
            var url = '{{ route("admin.kyc.action",":id") }}';
            url = url.replace(':id', id);
            $.get(url, function(data) {

                $('#kyc-action-data').append(data)
                imagePreview()
            })

            $('#kyc-action-modal').modal('toggle')
        })
    </script>
@endsection