<?php

namespace Payment\Midtrans;

use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Http;
use Payment\Transaction\BaseTxn;

class MidtransTxn extends BaseTxn
{
    private $merchantId;

    private $clientKey;

    private $serverKey;

    /**
     * @var mixed|string
     */
    public function __construct($txnInfo)
    {
        parent::__construct($txnInfo);
        $gatewayInfo = gateway_info('midtrans');
        $this->merchantId = $gatewayInfo->merchant_id;
        $this->clientKey = $gatewayInfo->client_key;
        $this->serverKey = $gatewayInfo->server_key;
    }

    public function deposit()
    {
        $data = [
            'transaction_details' => [
                'order_id' => $this->txn,
                'gross_amount' => intval($this->amount),
            ],
            'customer_details' => [
                'first_name' => $this->userName,
                'last_name' => $this->userName,
                'email' => $this->userEmail,
                'phone' => $this->userPhone,
            ],
        ];

        $response = Http::withHeaders([
            'Accept' => 'application/json',
            'Content-Type' => 'application/json',
            'Authorization' => 'Basic '.base64_encode($this->serverKey.':'),
        ])->post('https://app.midtrans.com/snap/v1/transactions', $data);

        $response = json_decode($response, true);
        $token = $response['token'];
        $url = $response['redirect_url'];
        $client_key = $this->clientKey;
        $success_url = route('status.success', ['reftrn' => Crypt::encryptString($this->txn)]);
        // $reftrn = Crypt::encryptString($this->txn);

        return view('frontend::deposit.midtrans', compact('token', 'url', 'client_key', 'success_url'));
    }
}
